/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.DisplayImplementation;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.LinuxDisplayPeerInfo;
import org.lwjgl.opengl.LinuxPbufferPeerInfo;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.PixelFormat;

final class LinuxDisplay
implements DisplayImplementation {
    private static final int FULLSCREEN_LEGACY = 1;
    private static final int FULLSCREEN_NETWM = 2;
    private static final int WINDOWED = 3;
    private static int current_window_mode = 3;
    private static final int XRANDR = 10;
    private static final int XF86VIDMODE = 11;
    private static final int NONE = 12;
    private static int current_displaymode_extension = 12;
    private static final int NUM_BUTTONS = 3;
    private static Thread current_awt_lock_owner;
    private static int awt_lock_count;
    private static int display_connection_usage_count;
    private static PeerInfo peer_info;
    private static ByteBuffer saved_gamma;
    private static ByteBuffer current_gamma;
    private static DisplayMode saved_mode;
    private static DisplayMode current_mode;

    LinuxDisplay() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer getCurrentGammaRamp() throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            block8: {
                ByteBuffer byteBuffer;
                LinuxDisplay.incDisplay();
                try {
                    if (!LinuxDisplay.isXF86VidModeSupported()) break block8;
                    byteBuffer = LinuxDisplay.nGetCurrentGammaRamp();
                }
                catch (Throwable throwable) {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                LinuxDisplay.decDisplay();
                return byteBuffer;
            }
            ByteBuffer byteBuffer = null;
            LinuxDisplay.decDisplay();
            return byteBuffer;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native ByteBuffer nGetCurrentGammaRamp() throws LWJGLException;

    private static int getBestDisplayModeExtension() {
        int result;
        if (LinuxDisplay.isXrandrSupported()) {
            LWJGLUtil.log("Using Xrandr for display mode switching");
            result = 10;
        } else if (LinuxDisplay.isXF86VidModeSupported()) {
            LWJGLUtil.log("Using XF86VidMode for display mode switching");
            result = 11;
        } else {
            LWJGLUtil.log("No display mode extensions available");
            result = 12;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isXrandrSupported() {
        if (Boolean.getBoolean("LWJGL_DISABLE_XRANDR")) {
            return false;
        }
        LinuxDisplay.lockAWT();
        try {
            boolean bl;
            LinuxDisplay.incDisplay();
            try {
                bl = LinuxDisplay.nIsXrandrSupported();
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException e) {
                    LWJGLUtil.log("Got exception while querying Xrandr support: " + e);
                    boolean bl2 = false;
                    return bl2;
                }
            }
            LinuxDisplay.decDisplay();
            return bl;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native boolean nIsXrandrSupported() throws LWJGLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isXF86VidModeSupported() {
        LinuxDisplay.lockAWT();
        try {
            boolean bl;
            LinuxDisplay.incDisplay();
            try {
                bl = LinuxDisplay.nIsXF86VidModeSupported();
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException e) {
                    LWJGLUtil.log("Got exception while querying XF86VM support: " + e);
                    boolean bl2 = false;
                    return bl2;
                }
            }
            LinuxDisplay.decDisplay();
            return bl;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native boolean nIsXF86VidModeSupported() throws LWJGLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isNetWMFullscreenSupported() throws LWJGLException {
        if (Boolean.getBoolean("LWJGL_DISABLE_NETWM")) {
            return false;
        }
        LinuxDisplay.lockAWT();
        try {
            boolean bl;
            LinuxDisplay.incDisplay();
            try {
                bl = LinuxDisplay.nIsNetWMFullscreenSupported();
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException e) {
                    LWJGLUtil.log("Got exception while querying NetWM support: " + e);
                    boolean bl2 = false;
                    return bl2;
                }
            }
            LinuxDisplay.decDisplay();
            return bl;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native boolean nIsNetWMFullscreenSupported() throws LWJGLException;

    static synchronized void lockAWT() {
        Thread this_thread = Thread.currentThread();
        while (current_awt_lock_owner != null && current_awt_lock_owner != this_thread) {
            try {
                (class$org$lwjgl$opengl$LinuxDisplay == null ? LinuxDisplay.class$("org.lwjgl.opengl.LinuxDisplay") : class$org$lwjgl$opengl$LinuxDisplay).wait();
            }
            catch (InterruptedException e) {
                LWJGLUtil.log("Interrupted while waiting for awt lock: " + e);
            }
        }
        if (awt_lock_count == 0) {
            current_awt_lock_owner = this_thread;
            try {
                LinuxDisplay.nLockAWT();
            }
            catch (LWJGLException e) {
                LWJGLUtil.log("Caught exception while locking AWT: " + e);
            }
        }
        ++awt_lock_count;
    }

    private static native void nLockAWT() throws LWJGLException;

    static synchronized void unlockAWT() {
        if (awt_lock_count <= 0) {
            throw new IllegalStateException("AWT not locked!");
        }
        if (Thread.currentThread() != current_awt_lock_owner) {
            throw new IllegalStateException("AWT already locked by " + current_awt_lock_owner);
        }
        if (--awt_lock_count == 0) {
            try {
                LinuxDisplay.nUnlockAWT();
            }
            catch (LWJGLException e) {
                LWJGLUtil.log("Caught exception while unlocking AWT: " + e);
            }
            current_awt_lock_owner = null;
            LinuxDisplay.class.notify();
        }
    }

    private static native void nUnlockAWT() throws LWJGLException;

    static void incDisplay() throws LWJGLException {
        if (display_connection_usage_count == 0) {
            GLContext.loadOpenGLLibrary();
            LinuxDisplay.openDisplay();
        }
        ++display_connection_usage_count;
    }

    static void decDisplay() {
        if (--display_connection_usage_count < 0) {
            throw new InternalError("display_connection_usage_count < 0: " + display_connection_usage_count);
        }
        if (display_connection_usage_count == 0) {
            LinuxDisplay.closeDisplay();
            GLContext.unloadOpenGLLibrary();
        }
    }

    private static native void openDisplay() throws LWJGLException;

    private static native void closeDisplay();

    private static int getWindowMode(boolean fullscreen) throws LWJGLException {
        if (fullscreen) {
            if (current_displaymode_extension == 10 && LinuxDisplay.isNetWMFullscreenSupported()) {
                LWJGLUtil.log("Using NetWM for fullscreen window");
                return 2;
            }
            LWJGLUtil.log("Using legacy mode for fullscreen window");
            return 1;
        }
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createWindow(DisplayMode mode, boolean fullscreen, int x, int y) throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            ByteBuffer handle = peer_info.lockAndGetHandle();
            try {
                current_window_mode = LinuxDisplay.getWindowMode(fullscreen);
                LinuxDisplay.nCreateWindow(handle, mode, current_window_mode, x, y);
            }
            finally {
                peer_info.unlock();
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nCreateWindow(ByteBuffer var0, DisplayMode var1, int var2, int var3, int var4) throws LWJGLException;

    public void destroyWindow() {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nDestroyWindow();
        LinuxDisplay.unlockAWT();
    }

    private static native void nDestroyWindow();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchDisplayMode(DisplayMode mode) throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.nSwitchDisplayMode(current_displaymode_extension, mode);
            current_mode = mode;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nSwitchDisplayMode(int var0, DisplayMode var1) throws LWJGLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDisplayMode() {
        LinuxDisplay.lockAWT();
        try {
            this.switchDisplayMode(saved_mode);
            if (LinuxDisplay.isXF86VidModeSupported()) {
                LinuxDisplay.doSetGamma(saved_gamma);
            }
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Caught exception while resetting mode: " + e);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int getGammaRampLength() {
        if (!LinuxDisplay.isXF86VidModeSupported()) {
            return 0;
        }
        LinuxDisplay.lockAWT();
        try {
            int n;
            LinuxDisplay.incDisplay();
            try {
                n = LinuxDisplay.nGetGammaRampLength();
            }
            catch (LWJGLException e) {
                LWJGLUtil.log("Got exception while querying gamma length: " + e);
                int n2 = 0;
                LinuxDisplay.decDisplay();
                LinuxDisplay.unlockAWT();
                return n2;
                {
                    catch (Throwable throwable) {
                        try {
                            LinuxDisplay.decDisplay();
                            throw throwable;
                        }
                        catch (LWJGLException e2) {
                            LWJGLUtil.log("Failed to get gamma ramp length: " + e2);
                            int n3 = 0;
                            return n3;
                        }
                    }
                }
            }
            LinuxDisplay.decDisplay();
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetGammaRampLength() throws LWJGLException;

    public void setGammaRamp(FloatBuffer gammaRamp) throws LWJGLException {
        if (!LinuxDisplay.isXF86VidModeSupported()) {
            throw new LWJGLException("No gamma ramp support (Missing XF86VM extension)");
        }
        LinuxDisplay.doSetGamma(LinuxDisplay.convertToNativeRamp(gammaRamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSetGamma(ByteBuffer native_gamma) throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.nSetGammaRamp(native_gamma);
            current_gamma = native_gamma;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nSetGammaRamp(ByteBuffer var0) throws LWJGLException;

    private static ByteBuffer convertToNativeRamp(FloatBuffer ramp) throws LWJGLException {
        return LinuxDisplay.nConvertToNativeRamp(ramp, ramp.position(), ramp.remaining());
    }

    private static native ByteBuffer nConvertToNativeRamp(FloatBuffer var0, int var1, int var2) throws LWJGLException;

    public String getAdapter() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayMode init() throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            current_displaymode_extension = LinuxDisplay.getBestDisplayModeExtension();
            if (current_displaymode_extension == 12) {
                throw new LWJGLException("No display mode extension is available");
            }
            DisplayMode[] modes = this.getAvailableDisplayModes();
            if (modes == null || modes.length == 0) {
                throw new LWJGLException("No modes available");
            }
            switch (current_displaymode_extension) {
                case 10: {
                    saved_mode = LinuxDisplay.getCurrentXRandrMode();
                    break;
                }
                case 11: {
                    saved_mode = modes[0];
                    break;
                }
                default: {
                    throw new LWJGLException("Unknown display mode extension: " + current_displaymode_extension);
                }
            }
            current_mode = saved_mode;
            current_gamma = saved_gamma = LinuxDisplay.getCurrentGammaRamp();
            DisplayMode displayMode = saved_mode;
            return displayMode;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DisplayMode getCurrentXRandrMode() throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            DisplayMode displayMode;
            LinuxDisplay.incDisplay();
            try {
                displayMode = LinuxDisplay.nGetCurrentXRandrMode();
            }
            catch (Throwable throwable) {
                LinuxDisplay.decDisplay();
                throw throwable;
            }
            LinuxDisplay.decDisplay();
            return displayMode;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native DisplayMode nGetCurrentXRandrMode() throws LWJGLException;

    public void setTitle(String title) {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nSetTitle(title);
        LinuxDisplay.unlockAWT();
    }

    private static native void nSetTitle(String var0);

    public boolean isCloseRequested() {
        LinuxDisplay.lockAWT();
        boolean result = LinuxDisplay.nIsCloseRequested();
        LinuxDisplay.unlockAWT();
        return result;
    }

    private static native boolean nIsCloseRequested();

    public boolean isVisible() {
        LinuxDisplay.lockAWT();
        boolean result = LinuxDisplay.nIsVisible();
        LinuxDisplay.unlockAWT();
        return result;
    }

    private static native boolean nIsVisible();

    public boolean isActive() {
        LinuxDisplay.lockAWT();
        boolean result = LinuxDisplay.nIsActive(current_window_mode);
        LinuxDisplay.unlockAWT();
        return result;
    }

    private static native boolean nIsActive(int var0);

    public boolean isDirty() {
        LinuxDisplay.lockAWT();
        boolean result = LinuxDisplay.nIsDirty();
        LinuxDisplay.unlockAWT();
        return result;
    }

    private static native boolean nIsDirty();

    public PeerInfo createPeerInfo(PixelFormat pixel_format) throws LWJGLException {
        peer_info = new LinuxDisplayPeerInfo(pixel_format);
        return peer_info;
    }

    public void update() {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.nUpdate(current_displaymode_extension, current_window_mode, saved_gamma, current_gamma, saved_mode, current_mode);
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Caught exception while processing messages: " + e);
        }
        LinuxDisplay.unlockAWT();
    }

    private static native void nUpdate(int var0, int var1, ByteBuffer var2, ByteBuffer var3, DisplayMode var4, DisplayMode var5) throws LWJGLException;

    public void reshape(int x, int y, int width, int height) {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nReshape(x, y, width, height);
        LinuxDisplay.unlockAWT();
    }

    private static native void nReshape(int var0, int var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayMode[] getAvailableDisplayModes() throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            DisplayMode[] displayModeArray;
            LinuxDisplay.incDisplay();
            try {
                DisplayMode[] modes;
                displayModeArray = modes = LinuxDisplay.nGetAvailableDisplayModes(current_displaymode_extension);
            }
            catch (Throwable throwable) {
                LinuxDisplay.decDisplay();
                throw throwable;
            }
            LinuxDisplay.decDisplay();
            return displayModeArray;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native DisplayMode[] nGetAvailableDisplayModes(int var0) throws LWJGLException;

    public boolean hasWheel() {
        return true;
    }

    public int getButtonCount() {
        return 3;
    }

    public void createMouse() {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nCreateMouse(current_window_mode);
        LinuxDisplay.unlockAWT();
    }

    private static native void nCreateMouse(int var0);

    public void destroyMouse() {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nDestroyMouse();
        LinuxDisplay.unlockAWT();
    }

    private static native void nDestroyMouse();

    public void pollMouse(IntBuffer coord_buffer, ByteBuffer buttons) {
        this.update();
        LinuxDisplay.lockAWT();
        LinuxDisplay.nPollMouse(coord_buffer, buttons);
        LinuxDisplay.unlockAWT();
    }

    private static native void nPollMouse(IntBuffer var0, ByteBuffer var1);

    public int readMouse(IntBuffer buffer, int buffer_position) {
        this.update();
        LinuxDisplay.lockAWT();
        int count = LinuxDisplay.nReadMouse(buffer, buffer_position);
        LinuxDisplay.unlockAWT();
        return count;
    }

    private static native int nReadMouse(IntBuffer var0, int var1);

    public void setCursorPosition(int x, int y) {
        LinuxDisplay.lockAWT();
        this.nSetCursorPosition(x, y);
        LinuxDisplay.unlockAWT();
    }

    private native void nSetCursorPosition(int var1, int var2);

    public void grabMouse(boolean grab) {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nGrabMouse(current_window_mode, grab);
        LinuxDisplay.unlockAWT();
    }

    private static native void nGrabMouse(int var0, boolean var1);

    public int getNativeCursorCapabilities() {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.incDisplay();
            int caps = LinuxDisplay.nGetNativeCursorCapabilities();
            LinuxDisplay.decDisplay();
            int n = caps;
            return n;
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetNativeCursorCapabilities() throws LWJGLException;

    public void setNativeCursor(Object handle) throws LWJGLException {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nSetNativeCursor(handle);
        LinuxDisplay.unlockAWT();
    }

    private static native void nSetNativeCursor(Object var0) throws LWJGLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinCursorSize() {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.incDisplay();
            int min_size = LinuxDisplay.nGetMinCursorSize();
            LinuxDisplay.decDisplay();
            int n = min_size;
            return n;
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Exception occurred in getMinCursorSize: " + e);
            int n = 0;
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetMinCursorSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxCursorSize() {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.incDisplay();
            int max_size = LinuxDisplay.nGetMaxCursorSize();
            LinuxDisplay.decDisplay();
            int n = max_size;
            return n;
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Exception occurred in getMaxCursorSize: " + e);
            int n = 0;
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetMaxCursorSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createKeyboard() throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.nCreateKeyboard(current_window_mode);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nCreateKeyboard(int var0) throws LWJGLException;

    public void destroyKeyboard() {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nDestroyKeyboard();
        LinuxDisplay.unlockAWT();
    }

    private static native void nDestroyKeyboard();

    public void pollKeyboard(ByteBuffer keyDownBuffer) {
        this.update();
        LinuxDisplay.lockAWT();
        LinuxDisplay.nPollKeyboard(keyDownBuffer);
        LinuxDisplay.unlockAWT();
    }

    private static native void nPollKeyboard(ByteBuffer var0);

    public int readKeyboard(IntBuffer buffer, int buffer_position) {
        this.update();
        LinuxDisplay.lockAWT();
        int count = LinuxDisplay.nReadKeyboard(buffer, buffer_position);
        LinuxDisplay.unlockAWT();
        return count;
    }

    private static native int nReadKeyboard(IntBuffer var0, int var1);

    public int isStateKeySet(int key) {
        return 2;
    }

    private static native ByteBuffer nCreateCursor(int var0, int var1, int var2, int var3, int var4, IntBuffer var5, int var6, IntBuffer var7, int var8) throws LWJGLException;

    public Object createCursor(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.incDisplay();
            try {
                ByteBuffer byteBuffer = LinuxDisplay.nCreateCursor(width, height, xHotspot, yHotspot, numImages, images, images.position(), delays, delays != null ? delays.position() : -1);
                return byteBuffer;
            }
            catch (LWJGLException e) {
                LinuxDisplay.decDisplay();
                throw e;
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    public void destroyCursor(Object cursorHandle) {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nDestroyCursor(cursorHandle);
        LinuxDisplay.decDisplay();
        LinuxDisplay.unlockAWT();
    }

    private static native void nDestroyCursor(Object var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPbufferCapabilities() {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.incDisplay();
            int caps = LinuxDisplay.nGetPbufferCapabilities();
            LinuxDisplay.decDisplay();
            int n = caps;
            return n;
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Exception occurred in getPbufferCapabilities: " + e);
            int n = 0;
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetPbufferCapabilities();

    public boolean isBufferLost(PeerInfo handle) {
        return false;
    }

    public PeerInfo createPbuffer(int width, int height, PixelFormat pixel_format, IntBuffer pixelFormatCaps, IntBuffer pBufferAttribs) throws LWJGLException {
        return new LinuxPbufferPeerInfo(width, height, pixel_format);
    }

    public void setPbufferAttrib(PeerInfo handle, int attrib, int value) {
        throw new UnsupportedOperationException();
    }

    public void bindTexImageToPbuffer(PeerInfo handle, int buffer) {
        throw new UnsupportedOperationException();
    }

    public void releaseTexImageFromPbuffer(PeerInfo handle, int buffer) {
        throw new UnsupportedOperationException();
    }

    public int setIcon(ByteBuffer[] icons) {
        for (int i = 0; i < icons.length; ++i) {
            int size = icons[i].limit() / 4;
            if ((int)Math.sqrt(size) != 32) continue;
            LinuxDisplay.nSetWindowIcon(icons[i]);
            return 1;
        }
        return 0;
    }

    private static native int nSetWindowIcon(ByteBuffer var0);

    static {
        display_connection_usage_count = 0;
    }
}

