/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;

abstract class EventQueue {
    private static final int QUEUE_SIZE = 200;
    private final int event_size;
    private final IntBuffer queue;

    protected EventQueue(int event_size) {
        this.event_size = event_size;
        this.queue = ByteBuffer.allocateDirect(200 * event_size).asIntBuffer();
    }

    protected synchronized void clearEvents() {
        this.queue.clear();
    }

    public synchronized int copyEvents(IntBuffer dest) {
        int old_position = dest.position();
        this.queue.flip();
        int old_limit = this.queue.limit();
        if (dest.remaining() < this.queue.remaining()) {
            this.queue.limit(dest.remaining() + this.queue.position());
        }
        dest.put(this.queue);
        this.queue.limit(old_limit);
        this.queue.compact();
        int num_events = (dest.position() - old_position) / this.event_size;
        dest.position(old_position);
        return num_events;
    }

    public synchronized boolean putEvent(int[] event) {
        if (event.length != this.event_size) {
            throw new IllegalArgumentException("Internal error: event size " + this.event_size + " does not equals the given event size " + event.length);
        }
        if (this.queue.remaining() >= event.length) {
            this.queue.put(event);
            return true;
        }
        return false;
    }
}

