/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Context;
import org.lwjgl.opengl.DisplayImplementation;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.Util;

public final class Display {
    private static final DisplayImplementation display_impl;
    private static final DisplayMode initial_mode;
    private static DisplayMode current_mode;
    private static long timeNow;
    private static long timeThen;
    private static int x;
    private static ByteBuffer[] cached_icons;
    private static int y;
    private static String title;
    private static boolean fullscreen;
    private static int swap_interval;
    private static PeerInfo peer_info;
    private static Context context;
    private static boolean window_created;
    private static long timeLate;

    public static Drawable getDrawable() {
        if (context != null) {
            return new Drawable(){

                public Context getContext() {
                    return context;
                }
            };
        }
        return null;
    }

    private static DisplayImplementation createDisplayImplementation() {
        String class_name;
        switch (LWJGLUtil.getPlatform()) {
            case 1: {
                class_name = "org.lwjgl.opengl.LinuxDisplay";
                break;
            }
            case 3: {
                class_name = "org.lwjgl.opengl.Win32Display";
                break;
            }
            case 2: {
                class_name = "org.lwjgl.opengl.MacOSXDisplay";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported platform");
            }
        }
        try {
            Class<?> display_class = Class.forName(class_name);
            return (DisplayImplementation)display_class.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private Display() {
    }

    public static DisplayMode[] getAvailableDisplayModes() throws LWJGLException {
        DisplayMode[] unfilteredModes = display_impl.getAvailableDisplayModes();
        if (unfilteredModes == null) {
            return new DisplayMode[0];
        }
        HashSet<DisplayMode> modes = new HashSet<DisplayMode>(unfilteredModes.length);
        modes.addAll(Arrays.asList(unfilteredModes));
        DisplayMode[] filteredModes = new DisplayMode[modes.size()];
        modes.toArray(filteredModes);
        LWJGLUtil.log("Removed " + (unfilteredModes.length - filteredModes.length) + " duplicate displaymodes");
        return filteredModes;
    }

    public static DisplayMode getDisplayMode() {
        return current_mode;
    }

    public static void setDisplayMode(DisplayMode mode) throws LWJGLException {
        if (mode == null) {
            throw new NullPointerException("mode must be non-null");
        }
        current_mode = mode;
        if (Display.isCreated()) {
            Display.destroyWindow();
            if (!mode.isFullscreen()) {
                Display.resetFullscreen();
            }
            try {
                if (fullscreen) {
                    Display.switchDisplayMode();
                }
                Display.createWindow();
            }
            catch (LWJGLException e) {
                Display.destroyContext();
                display_impl.resetDisplayMode();
                throw e;
            }
        }
    }

    private static void createWindow() throws LWJGLException {
        int window_y;
        int window_x;
        if (window_created) {
            return;
        }
        if (!fullscreen) {
            if (x == -1 && y == -1) {
                window_x = Math.max(0, (initial_mode.getWidth() - current_mode.getWidth()) / 2);
                window_y = Math.max(0, (initial_mode.getHeight() - current_mode.getHeight()) / 2);
            } else {
                window_x = x;
                window_y = y;
            }
        } else {
            window_x = 0;
            window_y = 0;
        }
        display_impl.createWindow(current_mode, fullscreen, window_x, window_y);
        Display.makeCurrent();
        Display.setTitle(title);
        Display.initControls();
        Display.setSwapInterval(swap_interval);
        window_created = true;
        if (cached_icons != null) {
            Display.setIcon(cached_icons);
        } else {
            Display.setIcon(new ByteBuffer[]{LWJGLUtil.LWJGLIcon16x16, LWJGLUtil.LWJGLIcon32x32});
        }
    }

    private static void destroyWindow() {
        if (!window_created) {
            return;
        }
        try {
            if (context.isCurrent()) {
                Context.releaseCurrentContext();
            }
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Exception occurred while trying to release context");
        }
        if (Mouse.isCreated()) {
            Mouse.destroy();
        }
        if (Keyboard.isCreated()) {
            Keyboard.destroy();
        }
        display_impl.destroyWindow();
        window_created = false;
    }

    private static void switchDisplayMode() throws LWJGLException {
        if (!current_mode.isFullscreen()) {
            System.out.println("Switching to " + initial_mode);
            Display.setDisplayMode(initial_mode);
        }
        display_impl.switchDisplayMode(current_mode);
    }

    public static void setDisplayConfiguration(float gamma, float brightness, float contrast) throws LWJGLException {
        if (!Display.isCreated()) {
            throw new LWJGLException("Display not yet created.");
        }
        if (brightness < -1.0f || brightness > 1.0f) {
            throw new IllegalArgumentException("Invalid brightness value");
        }
        if (contrast < 0.0f) {
            throw new IllegalArgumentException("Invalid contrast value");
        }
        int rampSize = display_impl.getGammaRampLength();
        if (rampSize == 0) {
            throw new LWJGLException("Display configuration not supported");
        }
        FloatBuffer gammaRamp = BufferUtils.createFloatBuffer(rampSize);
        for (int i = 0; i < rampSize; ++i) {
            float intensity = (float)i / (float)(rampSize - 1);
            float rampEntry = (float)Math.pow(intensity, gamma);
            rampEntry += brightness;
            if ((rampEntry = (rampEntry - 0.5f) * contrast + 0.5f) > 1.0f) {
                rampEntry = 1.0f;
            } else if (rampEntry < 0.0f) {
                rampEntry = 0.0f;
            }
            gammaRamp.put(i, rampEntry);
        }
        display_impl.setGammaRamp(gammaRamp);
        LWJGLUtil.log("Gamma set, gamma = " + gamma + ", brightness = " + brightness + ", contrast = " + contrast);
    }

    public static void sync3(int fps) {
        float frameTime = 1.0f / (float)(fps > 1 ? fps - 1 : 1);
        timeNow = Sys.getTime();
        while (timeNow > timeThen && (float)(timeNow - timeThen) / (float)Sys.getTimerResolution() < frameTime) {
            Thread.yield();
            timeNow = Sys.getTime();
        }
        timeThen = timeNow;
    }

    public static void sync2(int fps) {
        long gapTo = Sys.getTimerResolution() / (long)fps + timeThen;
        timeNow = Sys.getTime();
        while (gapTo > timeNow + timeLate) {
            Thread.yield();
            timeNow = Sys.getTime();
        }
        timeLate = gapTo < timeNow ? timeNow - gapTo : 0L;
        timeThen = timeNow;
    }

    public static void sync(int fps) {
        long gapTo = Sys.getTimerResolution() / (long)fps + timeThen;
        timeNow = Sys.getTime();
        while (gapTo > timeNow + timeLate) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            timeNow = Sys.getTime();
        }
        timeLate = gapTo < timeNow ? timeNow - gapTo : 0L;
        timeThen = timeNow;
    }

    public static String getTitle() {
        return title;
    }

    private static void resetFullscreen() {
        if (fullscreen) {
            fullscreen = false;
            display_impl.resetDisplayMode();
        }
    }

    public static void setFullscreen(boolean fullscreen) throws LWJGLException {
        if (Display.fullscreen != fullscreen) {
            Display.fullscreen = fullscreen;
            if (!Display.isCreated()) {
                return;
            }
            Display.destroyWindow();
            try {
                if (fullscreen) {
                    Display.switchDisplayMode();
                } else {
                    display_impl.resetDisplayMode();
                }
                Display.createWindow();
            }
            catch (LWJGLException e) {
                Display.destroyContext();
                display_impl.resetDisplayMode();
                throw e;
            }
        }
    }

    public static boolean isFullscreen() {
        return fullscreen;
    }

    public static void setTitle(String newTitle) {
        if (newTitle == null) {
            newTitle = "";
        }
        title = newTitle;
        if (Display.isCreated()) {
            display_impl.setTitle(title);
        }
    }

    public static boolean isCloseRequested() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Cannot determine close requested state of uncreated window");
        }
        display_impl.update();
        return display_impl.isCloseRequested();
    }

    public static boolean isVisible() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Cannot determine minimized state of uncreated window");
        }
        display_impl.update();
        return display_impl.isVisible();
    }

    public static boolean isActive() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Cannot determine focused state of uncreated window");
        }
        display_impl.update();
        return display_impl.isActive();
    }

    public static boolean isDirty() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Cannot determine dirty state of uncreated window");
        }
        display_impl.update();
        return display_impl.isDirty();
    }

    public static void processMessages() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Display not created");
        }
        display_impl.update();
    }

    public static void swapBuffers() throws LWJGLException {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Display not created");
        }
        Util.checkGLError();
        Context.swapBuffers();
    }

    public static void update() {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Display not created");
        }
        if (Display.isVisible() || Display.isDirty()) {
            try {
                Display.swapBuffers();
            }
            catch (LWJGLException e) {
                throw new RuntimeException(e);
            }
        }
        Display.processMessages();
        if (Mouse.isCreated()) {
            Mouse.poll();
            Mouse.updateCursor();
        }
        if (Keyboard.isCreated()) {
            Keyboard.poll();
        }
        if (Controllers.isCreated()) {
            Controllers.poll();
        }
    }

    public static void releaseContext() throws LWJGLException {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Display is not created");
        }
        if (context.isCurrent()) {
            Context.releaseCurrentContext();
        }
    }

    public static void makeCurrent() throws LWJGLException {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Display is not created");
        }
        context.makeCurrent();
    }

    public static void create() throws LWJGLException {
        Display.create(new PixelFormat());
    }

    public static void create(PixelFormat pixel_format) throws LWJGLException {
        Display.create(pixel_format, null);
    }

    public static void create(PixelFormat pixel_format, Drawable shared_drawable) throws LWJGLException {
        if (Display.isCreated()) {
            throw new IllegalStateException("Only one LWJGL context may be instantiated at any one time.");
        }
        if (pixel_format == null) {
            throw new NullPointerException("pixel_format cannot be null");
        }
        if (fullscreen) {
            Display.switchDisplayMode();
        }
        try {
            peer_info = display_impl.createPeerInfo(pixel_format);
            context = new Context(peer_info, shared_drawable != null ? shared_drawable.getContext() : null);
            try {
                Display.createWindow();
                Display.initContext();
            }
            catch (LWJGLException e) {
                Display.destroyContext();
                throw e;
            }
        }
        catch (LWJGLException e) {
            display_impl.resetDisplayMode();
            throw e;
        }
    }

    private static void initContext() {
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, current_mode.getWidth(), 0.0, current_mode.getHeight(), -1.0, 1.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glViewport(0, 0, current_mode.getWidth(), current_mode.getHeight());
    }

    public static DisplayImplementation getImplementation() {
        return display_impl;
    }

    static boolean getPrivilegedBoolean(final String property_name) {
        Boolean value = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(Boolean.getBoolean(property_name));
            }
        });
        return value;
    }

    private static void initControls() {
        if (!Display.getPrivilegedBoolean("org.lwjgl.opengl.Display.noinput")) {
            if (!Mouse.isCreated() && !Display.getPrivilegedBoolean("org.lwjgl.opengl.Display.nomouse")) {
                try {
                    Mouse.create();
                }
                catch (LWJGLException e) {
                    if (LWJGLUtil.DEBUG) {
                        e.printStackTrace(System.err);
                    }
                    LWJGLUtil.log("Failed to create Mouse: " + e);
                }
            }
            if (!Keyboard.isCreated() && !Display.getPrivilegedBoolean("org.lwjgl.opengl.Display.nokeyboard")) {
                try {
                    Keyboard.create();
                }
                catch (LWJGLException e) {
                    if (LWJGLUtil.DEBUG) {
                        e.printStackTrace(System.err);
                    }
                    LWJGLUtil.log("Failed to create Keyboard: " + e);
                }
            }
        }
    }

    public static void destroy() {
        if (!Display.isCreated()) {
            return;
        }
        Display.destroyWindow();
        Display.destroyContext();
        y = -1;
        x = -1;
        cached_icons = null;
        Display.reset();
    }

    private static void destroyContext() {
        try {
            context.forceDestroy();
            peer_info.destroy();
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
        finally {
            context = null;
        }
    }

    private static void reset() {
        display_impl.resetDisplayMode();
        current_mode = initial_mode;
    }

    public static Context getContext() {
        return context;
    }

    public static boolean isCreated() {
        return context != null;
    }

    public static void setSwapInterval(int value) {
        swap_interval = value;
        if (Display.isCreated()) {
            Context.setSwapInterval(swap_interval);
        }
    }

    public static void setVSyncEnabled(boolean sync) {
        Display.setSwapInterval(sync ? 1 : 0);
    }

    public static void setLocation(int x, int y) {
        if (fullscreen) {
            return;
        }
        if (Display.isCreated()) {
            display_impl.reshape(x, y, current_mode.getWidth(), current_mode.getHeight());
        }
        Display.x = x;
        Display.y = y;
    }

    public static String getAdapter() {
        return display_impl.getAdapter();
    }

    public static String getVersion() {
        return display_impl.getVersion();
    }

    public static int setIcon(ByteBuffer[] icons) {
        if (cached_icons != icons) {
            cached_icons = new ByteBuffer[icons.length];
            for (int i = 0; i < icons.length; ++i) {
                Display.cached_icons[i] = BufferUtils.createByteBuffer(icons[i].capacity());
                cached_icons[i].put(icons[i]);
                cached_icons[i].flip();
            }
        }
        if (Display.isCreated()) {
            return display_impl.setIcon(cached_icons);
        }
        return 0;
    }

    static {
        x = -1;
        y = -1;
        title = "Game";
        window_created = false;
        Sys.initialize();
        display_impl = Display.createDisplayImplementation();
        try {
            current_mode = initial_mode = display_impl.init();
            LWJGLUtil.log("Initial mode: " + initial_mode);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        public void run() {
                            Display.reset();
                        }
                    });
                    return null;
                }
            });
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
    }
}

