/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.opengl.AWTCanvasImplementation;
import org.lwjgl.opengl.Context;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.PixelFormat;

public class AWTGLCanvas
extends Canvas
implements Drawable,
ComponentListener,
HierarchyListener {
    private static final long serialVersionUID = 1L;
    private static final AWTCanvasImplementation implementation;
    private boolean update_context;
    private Object SYNC_LOCK = new Object();
    private final PixelFormat pixel_format;
    private final Drawable drawable;
    private PeerInfo peer_info;
    private Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpdate() {
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            this.update_context = true;
        }
    }

    public Context getContext() {
        return this.context;
    }

    public AWTGLCanvas() throws LWJGLException {
        this(new PixelFormat());
    }

    public AWTGLCanvas(PixelFormat pixel_format) throws LWJGLException {
        this(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice(), pixel_format);
    }

    public AWTGLCanvas(GraphicsDevice device, PixelFormat pixel_format) throws LWJGLException {
        this(device, pixel_format, null);
    }

    public AWTGLCanvas(GraphicsDevice device, PixelFormat pixel_format, Drawable drawable) throws LWJGLException {
        super(implementation.findConfiguration(device, pixel_format));
        if (pixel_format == null) {
            throw new NullPointerException("Pixel format must be non-null");
        }
        this.addHierarchyListener(this);
        this.addComponentListener(this);
        this.drawable = drawable;
        this.pixel_format = pixel_format;
    }

    public void addNotify() {
        super.addNotify();
    }

    public void removeNotify() {
        this.destroyContext();
        super.removeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSwapInterval(int swap_interval) {
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            if (this.context == null) {
                throw new IllegalStateException("Canvas not yet displayable");
            }
            Context.setSwapInterval(swap_interval);
        }
    }

    public void setVSyncEnabled(boolean enabled) {
        this.setSwapInterval(enabled ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapBuffers() throws LWJGLException {
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            if (this.context == null) {
                throw new IllegalStateException("Canvas not yet displayable");
            }
            Context.swapBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseContext() throws LWJGLException {
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            if (this.context == null) {
                throw new IllegalStateException("Canvas not yet displayable");
            }
            if (this.context.isCurrent()) {
                Context.releaseCurrentContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeCurrent() throws LWJGLException {
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            if (this.context == null) {
                throw new IllegalStateException("Canvas not yet displayable");
            }
            this.context.makeCurrent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyContext() {
        Object object = this.SYNC_LOCK;
        synchronized (object) {
            try {
                if (this.context != null) {
                    this.context.forceDestroy();
                    this.context = null;
                    this.peer_info.destroy();
                    this.peer_info = null;
                }
            }
            catch (LWJGLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void initGL() {
    }

    protected void paintGL() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics g) {
        try {
            if (this.peer_info == null) {
                this.peer_info = implementation.createPeerInfo(this, this.pixel_format);
            }
            this.peer_info.lockAndGetHandle();
            try {
                if (this.context == null) {
                    this.context = new Context(this.peer_info, this.drawable != null ? this.drawable.getContext() : null);
                    this.context.makeCurrent();
                    this.initGL();
                }
                this.context.makeCurrent();
                try {
                    if (this.update_context) {
                        this.context.update();
                        this.update_context = false;
                    }
                    this.paintGL();
                }
                finally {
                    Context.releaseCurrentContext();
                }
            }
            finally {
                this.peer_info.unlock();
            }
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.setUpdate();
    }

    public void componentMoved(ComponentEvent e) {
        this.setUpdate();
    }

    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        this.setUpdate();
    }

    public void setLocation(Point p) {
        super.setLocation(p);
        this.setUpdate();
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        this.setUpdate();
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.setUpdate();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.setUpdate();
    }

    public void hierarchyChanged(HierarchyEvent e) {
        this.setUpdate();
    }

    static {
        String class_name;
        Sys.initialize();
        switch (LWJGLUtil.getPlatform()) {
            case 1: {
                class_name = "org.lwjgl.opengl.LinuxCanvasImplementation";
                break;
            }
            case 3: {
                class_name = "org.lwjgl.opengl.Win32CanvasImplementation";
                break;
            }
            case 2: {
                class_name = "org.lwjgl.opengl.MacOSXCanvasImplementation";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported platform");
            }
        }
        try {
            Class<?> impl_class = Class.forName(class_name);
            implementation = (AWTCanvasImplementation)impl_class.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

