/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.sprites.Scaled;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;

public class ScaleCommand
extends Command {
    public static final long serialVersionUID = 1L;
    private int xdelta;
    private int ydelta;
    private boolean relative;
    private int duration;

    public boolean execute(Animated target, int tickRate) {
        int currentSequence = target.getSequence();
        int currentTick = target.getTick();
        if (currentTick == 0) {
            Scaled scaledTarget = (Scaled)((Object)target);
            if (this.relative) {
                scaledTarget.setScale(scaledTarget.getXScale() + this.xdelta, scaledTarget.getYScale() + this.ydelta);
            } else {
                scaledTarget.setScale(this.xdelta, this.ydelta);
            }
        }
        if (currentTick >= this.duration) {
            target.setSequence(++currentSequence);
            target.setTick(0);
            return true;
        }
        target.setTick(currentTick + tickRate);
        return false;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        String sdelta = XMLUtil.getString(element, "scale", "!");
        if (!sdelta.equals("!")) {
            if (sdelta.startsWith("+")) {
                this.relative = true;
                this.xdelta = FPMath.parse(sdelta.substring(1));
            } else if (sdelta.startsWith("-")) {
                this.relative = true;
                this.xdelta = FPMath.parse(sdelta);
            } else {
                this.xdelta = FPMath.parse(sdelta);
            }
            this.ydelta = this.xdelta;
        } else {
            String sxdelta = XMLUtil.getString(element, "xscale");
            if (sxdelta.startsWith("+")) {
                this.relative = true;
                this.xdelta = FPMath.parse(sxdelta.substring(1));
            } else if (sxdelta.startsWith("-")) {
                this.relative = true;
                this.xdelta = FPMath.parse(sxdelta);
            } else {
                this.xdelta = FPMath.parse(sxdelta);
            }
            String sydelta = XMLUtil.getString(element, "yscale");
            if (sydelta.startsWith("+")) {
                this.relative = true;
                this.ydelta = FPMath.parse(sydelta.substring(1));
            } else if (sydelta.startsWith("-")) {
                this.relative = true;
                this.ydelta = FPMath.parse(sydelta);
            } else {
                this.ydelta = FPMath.parse(sydelta);
            }
        }
        this.duration = XMLUtil.getInt(element, "d", 0);
    }

    protected void doCreate() throws Exception {
    }

    protected void doDestroy() {
    }
}

