/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import com.shavenpuppy.jglib.Image;
import com.shavenpuppy.jglib.Palette;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GL;
import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import com.shavenpuppy.jglib.resources.ImageWrapper;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.glu.GLU;
import org.w3c.dom.Element;

public class GLTexture
extends GLBaseTexture {
    public static final long serialVersionUID = 1L;
    protected String url;
    protected boolean discardImage;
    protected boolean discardImageResource;
    protected int dstFormat;
    protected int srcFormat = -1;
    protected transient ImageWrapper imageResource;
    protected transient Image image;
    protected transient Palette palette;
    protected transient int width;
    protected transient int height;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.opengl.GLTexture");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public GLTexture(String name) {
        super(name);
    }

    public GLTexture(String name, String url, int target, int dstFormat, int minMode, int magMode, boolean wrap) {
        super(name, target, minMode, magMode, wrap);
        this.url = url;
        this.dstFormat = dstFormat;
        this.discardImage = true;
        this.discardImageResource = true;
    }

    public GLTexture(String name, ImageWrapper imageResource, int target, int dstFormat, int minMode, int magMode, boolean wrap) {
        super(name, target, minMode, magMode, wrap);
        this.imageResource = imageResource;
        this.dstFormat = dstFormat;
        this.discardImage = true;
    }

    public GLTexture(String name, Image image, int target, int dstFormat, int minMode, int magMode, boolean wrap) {
        super(name, target, minMode, magMode, wrap);
        this.image = image;
        this.dstFormat = dstFormat;
        this.discardImageResource = true;
    }

    private int decodeSourceFormat(Image textureImage) {
        ContextCapabilities capabilities = GLContext.getCapabilities();
        switch (textureImage.getType()) {
            case 0: {
                return 6407;
            }
            case 1: {
                return 6408;
            }
            case 2: {
                return 6409;
            }
            case 3: {
                return 6410;
            }
            case 4: {
                throw new IllegalArgumentException("ARGB image format is not supported.");
            }
            case 5: {
                if (capabilities.GL_EXT_abgr) {
                    return 32768;
                }
                throw new IllegalArgumentException("ABGR image format is not supported.");
            }
            case 6: {
                if (capabilities.GL_EXT_bgra) {
                    return 32992;
                }
                throw new IllegalArgumentException("BGR image format is not supported.");
            }
            case 7: {
                if (capabilities.GL_EXT_bgra) {
                    return 32993;
                }
                throw new IllegalArgumentException("BGRA image format is not supported.");
            }
            case 8: {
                return 6400;
            }
        }
        throw new IllegalArgumentException("Unknown image format.");
    }

    protected void doCreateTexture() throws Exception {
        int ret;
        int elements;
        int wrapMode;
        if (this.url != null) {
            if (this.url.startsWith("classpath:")) {
                try {
                    this.image = Image.read(new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream(this.url.substring(10))));
                }
                catch (IOException e) {
                    System.out.println("Failed to load system resource: " + this.url.substring(10));
                    throw e;
                }
            } else if (this.url.startsWith("resource:")) {
                this.imageResource = (ImageWrapper)((Object)Resources.get(this.url.substring(9)));
            } else {
                this.image = Image.read(new BufferedInputStream(new URL(this.url).openStream()));
            }
        }
        if (this.imageResource != null) {
            this.image = this.imageResource.getImage();
        }
        GL11.glBindTexture((int)this.target, (int)this.texture);
        GL11.glPixelStorei((int)3317, (int)1);
        ContextCapabilities capabilities = GLContext.getCapabilities();
        int n = this.wrap ? 10497 : (wrapMode = capabilities.OpenGL12 ? 33071 : 10496);
        if (this.target == 3553) {
            GL11.glTexParameteri((int)this.target, (int)10243, (int)wrapMode);
        }
        GL11.glTexParameteri((int)this.target, (int)10242, (int)wrapMode);
        GL11.glTexParameteri((int)this.target, (int)10240, (int)this.magMode);
        GL11.glTexParameteri((int)this.target, (int)10241, (int)this.minMode);
        Image textureImage = this.preprocess();
        this.width = textureImage.getWidth();
        this.height = textureImage.getHeight();
        if (!(Util.nextPowerOf2(this.width) == this.width && Util.nextPowerOf2(this.height) == this.height || capabilities.GL_ARB_texture_non_power_of_two)) {
            throw new OpenGLException("Non-power-of-two texture not supported by card");
        }
        if (this.srcFormat == -1) {
            this.srcFormat = this.decodeSourceFormat(textureImage);
        }
        this.palette = textureImage.getPalette();
        if (!$assertionsDisabled && this.srcFormat == 8 && this.palette == null) {
            throw new AssertionError((Object)"No palette in image");
        }
        if (this.srcFormat == -1) {
            this.srcFormat = this.dstFormat;
        }
        switch (this.srcFormat) {
            case 6403: 
            case 6404: 
            case 6405: 
            case 6406: 
            case 6409: {
                elements = 1;
                break;
            }
            case 6410: {
                elements = 2;
                break;
            }
            case 6656: {
                elements = 1;
                break;
            }
            case 6407: 
            case 32992: {
                elements = 3;
                break;
            }
            case 6408: 
            case 32768: 
            case 32993: {
                elements = 4;
                break;
            }
            default: {
                throw new OpenGLException("Unknown format " + this.srcFormat);
            }
        }
        if (this.dstFormat == 34029 && !capabilities.GL_ARB_texture_compression) {
            this.dstFormat = 6407;
        } else if (this.dstFormat == 34030 && !capabilities.GL_ARB_texture_compression) {
            this.dstFormat = 6408;
        }
        if (this.target == 3552) {
            GL11.glTexImage1D((int)this.target, (int)0, (int)this.dstFormat, (int)this.width, (int)0, (int)this.srcFormat, (int)5121, (ByteBuffer)textureImage.getData());
        } else if (this.target == 3553) {
            GL11.glTexImage2D((int)this.target, (int)0, (int)this.dstFormat, (int)this.width, (int)this.height, (int)0, (int)this.srcFormat, (int)5121, (ByteBuffer)textureImage.getData());
        }
        if ((this.minMode == 9987 || this.minMode == 9985) && this.target == 3553 && (ret = GLU.gluBuild2DMipmaps((int)3553, (int)elements, (int)this.width, (int)this.height, (int)this.srcFormat, (int)5121, (ByteBuffer)textureImage.getData())) != 0) {
            throw new OpenGLException("Failure creating 2D mipmaps for " + this + ": " + GLU.gluGetString((int)ret));
        }
        if (this.discardImage) {
            this.image = null;
        }
        if (this.discardImageResource) {
            this.imageResource = null;
        }
        textureImage.dispose();
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getWidth() {
        return this.width;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.url = XMLUtil.getString(element, "url", null);
        this.target = GL.decode(XMLUtil.getString(element, "target"));
        this.dstFormat = GL.decode(XMLUtil.getString(element, "dst"));
        this.srcFormat = XMLUtil.getString(element, "src", null) != null ? GL.decode(XMLUtil.getString(element, "src")) : -1;
        if (this.srcFormat == -1 && this.url == null) {
            this.width = XMLUtil.getInt(element, "width");
            this.height = XMLUtil.getInt(element, "height");
        }
        this.minMode = GL.decode(XMLUtil.getString(element, "min"));
        this.magMode = GL.decode(XMLUtil.getString(element, "mag"));
        this.wrap = 1 == GL.decode(XMLUtil.getString(element, "wrap"));
    }

    protected Image preprocess() {
        if (this.image == null) {
            int type;
            switch (this.dstFormat) {
                case 6407: {
                    type = 0;
                    break;
                }
                case 6408: {
                    type = 1;
                    break;
                }
                case 6409: {
                    type = 2;
                    break;
                }
                case 6410: {
                    type = 3;
                    break;
                }
                default: {
                    type = 1;
                }
            }
            return new Image(this.width, this.height, type);
        }
        return this.image;
    }
}

