/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import com.shavenpuppy.jglib.Font;
import com.shavenpuppy.jglib.Glyph;
import com.shavenpuppy.jglib.util.Decodeable;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.lwjgl.util.Point;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.WritablePoint;
import org.lwjgl.util.WritableRectangle;

public class TextLayout {
    private final Font font;
    private final Glyph[] glyph;
    private int numGlyphs;
    private final Format format;
    private HorizontalAlignment alignment;
    public static final HorizontalAlignment LEFT = new HorizontalAlignment("Left"){
        private static final long serialVersionUID = 1L;

        private Object readResolve() throws ObjectStreamException {
            return LEFT;
        }
    };
    public static final HorizontalAlignment RIGHT = new HorizontalAlignment("Right"){
        private static final long serialVersionUID = 1L;

        private Object readResolve() throws ObjectStreamException {
            return RIGHT;
        }
    };
    public static final HorizontalAlignment CENTERED = new HorizontalAlignment("Centered"){
        private static final long serialVersionUID = 1L;

        private Object readResolve() throws ObjectStreamException {
            return CENTERED;
        }
    };
    private final int[] x;
    private final int[] y;
    private int width;
    private int height;
    private int penX;
    private int penY;
    private static final Rectangle tempBounds = new Rectangle();
    private static final Point tempPoint = new Point();
    public static final Format NO_WRAP = new NoWrap();
    public static final Format WRAPPED = new Wrapped();
    public static final Format WORD_WRAP = new WordWrapped();
    public static final Format JUSTIFIED = new Justified();

    public TextLayout(Font font, String text, int width, Format format, HorizontalAlignment alignment) {
        this.font = font;
        this.width = width;
        this.format = format;
        this.alignment = alignment;
        this.glyph = new Glyph[text.length()];
        this.x = new int[this.glyph.length];
        this.y = new int[this.glyph.length];
        this.doLayout(text);
    }

    private void doLayout(String text) {
        while (text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(text, "\n", true);
        boolean lastTokenWasParagraph = true;
        while (st.hasMoreTokens()) {
            String paragraph = st.nextToken();
            if ("\n".equals(paragraph)) {
                if (lastTokenWasParagraph) {
                    this.penY -= this.font.getAscent() + this.font.getDescent() + this.font.getLeading();
                }
                lastTokenWasParagraph = true;
                continue;
            }
            lastTokenWasParagraph = false;
            this.format.format(this, paragraph, st.hasMoreTokens());
        }
        this.height = -this.penY;
    }

    public void getGlyphs(Glyph[] glyph, int[] x, int[] y) {
        System.arraycopy(this.glyph, 0, glyph, 0, this.numGlyphs);
        System.arraycopy(this.x, 0, x, 0, this.numGlyphs);
        System.arraycopy(this.y, 0, y, 0, this.numGlyphs);
    }

    public Font getFont() {
        return this.font;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getNumGlyphs() {
        return this.numGlyphs;
    }

    private void nextLine(boolean isLastParagraph) {
        this.penY -= this.font.getDescent();
        if (!isLastParagraph) {
            this.penY -= this.font.getLeading();
        }
        this.penX = 0;
    }

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    private void align(int startGlyph, int advance) {
        int dx = this.alignment == RIGHT ? this.width - advance : (this.alignment == CENTERED ? this.width - advance >> 1 : 0);
        int i = startGlyph;
        while (i < this.numGlyphs) {
            int n = i++;
            this.x[n] = this.x[n] + dx;
        }
    }

    public void apply(Target target) {
        target.setNumGlyphs(this.numGlyphs);
        int i = 0;
        while (i < this.numGlyphs) {
            target.setGlyph(i, this.glyph[i], this.x[i], this.y[i]);
            ++i;
        }
    }

    public static abstract class HorizontalAlignment
    implements Serializable,
    Decodeable {
        public static final long serialVersionUID = 1L;
        private final String display;

        private HorizontalAlignment(String display) {
            this.display = display;
        }

        public String toString() {
            return this.display;
        }

        public static Object decode(String in) throws Exception {
            if (in.equalsIgnoreCase(TextLayout.LEFT.display)) {
                return LEFT;
            }
            if (in.equalsIgnoreCase(TextLayout.RIGHT.display)) {
                return RIGHT;
            }
            if (in.equalsIgnoreCase(TextLayout.CENTERED.display)) {
                return CENTERED;
            }
            throw new Exception("Unknown horizontal alignment '" + in + "'");
        }
    }

    public static interface Target {
        public void setNumGlyphs(int var1);

        public void setGlyph(int var1, Glyph var2, int var3, int var4);
    }

    public static abstract class Format
    implements Serializable,
    Decodeable {
        public static long serialVersionUID = 1L;
        private final String display;

        private Format(String display) {
            this.display = display;
        }

        public String toString() {
            return this.display;
        }

        abstract void format(TextLayout var1, String var2, boolean var3);

        public static Object decode(String in) throws Exception {
            if (in.equalsIgnoreCase(TextLayout.NO_WRAP.display)) {
                return NO_WRAP;
            }
            if (in.equalsIgnoreCase(TextLayout.WRAPPED.display)) {
                return WRAPPED;
            }
            if (in.equalsIgnoreCase(TextLayout.JUSTIFIED.display)) {
                return JUSTIFIED;
            }
            if (in.equalsIgnoreCase(TextLayout.WORD_WRAP.display)) {
                return WORD_WRAP;
            }
            throw new Exception("Unknown text format '" + in + "'");
        }
    }

    private static final class NoWrap
    extends Format {
        public static final long serialVersionUID = 1L;

        NoWrap() {
            super("None");
        }

        void format(TextLayout layout, String paragraph, boolean lastParagraph) {
            int n = paragraph.length();
            Glyph last = null;
            TextLayout textLayout = layout;
            textLayout.penY = textLayout.penY - layout.font.getAscent();
            int i = 0;
            while (i < n) {
                Glyph next = layout.font.map(paragraph.charAt(i));
                next.getBounds((WritableRectangle)tempBounds);
                next.getBearing((WritablePoint)tempPoint);
                ((TextLayout)layout).x[((TextLayout)layout).numGlyphs] = tempPoint.getX() + layout.penX - next.getKerningAfter(last);
                ((TextLayout)layout).y[((TextLayout)layout).numGlyphs] = layout.penY + tempPoint.getY();
                Glyph[] glyphArray = layout.glyph;
                TextLayout textLayout2 = layout;
                int n2 = textLayout2.numGlyphs;
                textLayout2.numGlyphs = n2 + 1;
                glyphArray[n2] = next;
                TextLayout textLayout3 = layout;
                textLayout3.penX = textLayout3.penX + (next.getAdvance() + next.getKerningAfter(last));
                ++i;
            }
            if (lastParagraph) {
                layout.align(0, layout.penX);
                layout.nextLine(true);
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return NO_WRAP;
        }
    }

    private static final class Wrapped
    extends Format {
        public static final long serialVersionUID = 1L;

        Wrapped() {
            super("Character Wrap");
        }

        void format(TextLayout layout, String paragraph, boolean lastParagraph) {
            int n = paragraph.length();
            Glyph last = null;
            int lastWidth = 0;
            int lastAdvance = 0;
            int startGlyph = layout.numGlyphs;
            TextLayout textLayout = layout;
            textLayout.penY = textLayout.penY - layout.font.getAscent();
            int i = 0;
            while (i < n) {
                Glyph next = layout.font.map(paragraph.charAt(i));
                next.getBounds((WritableRectangle)tempBounds);
                next.getBearing((WritablePoint)tempPoint);
                if (layout.penX + tempPoint.getX() + tempBounds.getWidth() - next.getKerningAfter(last) > layout.width) {
                    layout.align(startGlyph, layout.penX + lastWidth - lastAdvance);
                    startGlyph = layout.numGlyphs;
                    layout.nextLine(false);
                    TextLayout textLayout2 = layout;
                    textLayout2.penY = textLayout2.penY - (layout.font.getAscent() + layout.font.getDescent() + layout.font.getLeading());
                    last = null;
                } else {
                    last = next;
                }
                ((TextLayout)layout).x[((TextLayout)layout).numGlyphs] = tempPoint.getX() + layout.penX - next.getKerningAfter(last);
                ((TextLayout)layout).y[((TextLayout)layout).numGlyphs] = layout.penY + tempPoint.getY();
                ((TextLayout)layout).glyph[((TextLayout)layout).numGlyphs] = next;
                lastAdvance = next.getAdvance() + next.getKerningAfter(last);
                TextLayout textLayout3 = layout;
                textLayout3.penX = textLayout3.penX + lastAdvance;
                lastWidth = layout.x[layout.numGlyphs] - tempPoint.getX();
                TextLayout textLayout4 = layout;
                textLayout4.numGlyphs = textLayout4.numGlyphs + 1;
                ++i;
            }
            layout.align(startGlyph, layout.penX + lastWidth - lastAdvance);
            layout.nextLine(lastParagraph);
        }

        private Object readResolve() throws ObjectStreamException {
            return WRAPPED;
        }
    }

    private static final class WordWrapped
    extends Format {
        public static final long serialVersionUID = 1L;

        WordWrapped() {
            super("Word Wrap");
        }

        void format(TextLayout layout, String paragraph, boolean lastParagraph) {
            StringTokenizer st = new StringTokenizer(paragraph, " ", false);
            int lastGlyphWidth = 0;
            int lastAdvanceWidth = 0;
            int startGlyph = layout.numGlyphs;
            boolean firstWordDone = false;
            TextLayout textLayout = layout;
            textLayout.penY = textLayout.penY - layout.font.getAscent();
            while (st.hasMoreTokens()) {
                Glyph next;
                String word = st.nextToken();
                Glyph last = null;
                int w = 0;
                int lastWidthOffset = 0;
                int lastAdvance = 0;
                int n = word.length();
                int i = 0;
                while (i < n) {
                    next = layout.font.map(word.charAt(i));
                    next.getBounds((WritableRectangle)tempBounds);
                    next.getBearing((WritablePoint)tempPoint);
                    lastAdvance = next.getAdvance() + next.getKerningAfter(last);
                    lastWidthOffset = tempPoint.getX() + tempBounds.getWidth() - next.getKerningAfter(last);
                    w += lastAdvance;
                    last = next;
                    ++i;
                }
                w = w - lastAdvance + lastWidthOffset;
                if (firstWordDone && layout.penX + w > layout.width) {
                    layout.align(startGlyph, layout.penX + lastGlyphWidth - lastAdvanceWidth);
                    startGlyph = layout.numGlyphs;
                    layout.nextLine(false);
                    TextLayout textLayout2 = layout;
                    textLayout2.penY = textLayout2.penY - layout.font.getAscent();
                    firstWordDone = false;
                } else if (firstWordDone) {
                    Glyph space = layout.font.map(' ');
                    TextLayout textLayout3 = layout;
                    textLayout3.penX = textLayout3.penX + space.getAdvance();
                }
                last = null;
                i = 0;
                while (i < n) {
                    next = layout.font.map(word.charAt(i));
                    next.getBounds((WritableRectangle)tempBounds);
                    next.getBearing((WritablePoint)tempPoint);
                    ((TextLayout)layout).x[((TextLayout)layout).numGlyphs] = tempPoint.getX() + layout.penX - next.getKerningAfter(last);
                    ((TextLayout)layout).y[((TextLayout)layout).numGlyphs] = layout.penY + tempPoint.getY();
                    ((TextLayout)layout).glyph[((TextLayout)layout).numGlyphs] = next;
                    lastAdvance = next.getAdvance() + next.getKerningAfter(last);
                    TextLayout textLayout4 = layout;
                    textLayout4.penX = textLayout4.penX + lastAdvance;
                    TextLayout textLayout5 = layout;
                    textLayout5.numGlyphs = textLayout5.numGlyphs + 1;
                    last = next;
                    ++i;
                }
                firstWordDone = true;
            }
            layout.align(startGlyph, layout.penX + lastGlyphWidth - lastAdvanceWidth);
            layout.nextLine(lastParagraph);
        }

        private Object readResolve() throws ObjectStreamException {
            return WORD_WRAP;
        }
    }

    private static final class Justified
    extends Format {
        public static final long serialVersionUID = 1L;

        Justified() {
            super("Justified");
        }

        void format(TextLayout layout, String paragraph, boolean lastParagraph) {
            TextLayout textLayout = layout;
            textLayout.penY = textLayout.penY - layout.font.getDescent();
            if (!lastParagraph) {
                TextLayout textLayout2 = layout;
                textLayout2.penY = textLayout2.penY - layout.font.getLeading();
            }
            layout.penX = 0;
        }

        private Object readResolve() throws ObjectStreamException {
            return JUSTIFIED;
        }
    }
}

