/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import com.shavenpuppy.jglib.Resource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class Resources {
    public static final boolean DEBUG = false;
    private static boolean runMode;
    private static final HashMap resourceMap;
    static final Thread allocationThread;
    private static final SortedSet unnamedSet;
    private static final ArrayList creating;
    private static final ArrayList destroying;
    private static int numQueued;
    private static int numCreated;
    private static CreatingCallback creatingCallback;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.Resources");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        boolean bl = $assertionsDisabled = !clazz.desiredAssertionStatus();
        if (System.getProperty("java.protocol.handler.pkgs") == null) {
            System.getProperties().put("java.protocol.handler.pkgs", "com.shavenpuppy.jglib.resources.protocol");
        }
        resourceMap = new HashMap(256, 0.25f);
        allocationThread = Thread.currentThread();
        unnamedSet = new TreeSet();
        creating = new ArrayList();
        destroying = new ArrayList();
    }

    private Resources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource peek(String name) throws NullPointerException {
        Resource ret = null;
        HashMap hashMap = resourceMap;
        synchronized (hashMap) {
            ret = (Resource)resourceMap.get(name.toLowerCase());
        }
        if (ret == null) {
            throw new NullPointerException("Resource " + name + " was not found.");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource get(String name) throws Exception {
        Resource ret = null;
        HashMap hashMap = resourceMap;
        synchronized (hashMap) {
            ret = (Resource)resourceMap.get(name.toLowerCase());
        }
        if (ret == null) {
            System.out.println("WARNING: Resource '" + name + "' not found");
            return null;
        }
        if (!ret.isCreated()) {
            if (creatingCallback != null) {
                creatingCallback.onCreating(ret);
            }
            ++numQueued;
            ret.create();
            ++numCreated;
            --numQueued;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(String name) {
        HashMap hashMap = resourceMap;
        synchronized (hashMap) {
            return resourceMap.containsKey(name.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(Resource resource) {
        if (resource.getName() == null) {
            throw new RuntimeException("Unnamed resource " + resource + " cannot be put in the named set");
        }
        HashMap hashMap = resourceMap;
        synchronized (hashMap) {
            Resource old = resourceMap.put(resource.getName().toLowerCase(), resource);
            if (old != null) {
                old.deregister();
            }
            resource.register();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(Resource resource) {
        if (resource.getName() != null) {
            throw new RuntimeException("Named resource " + resource + " cannot be added to the unnamed set.");
        }
        SortedSet sortedSet = unnamedSet;
        synchronized (sortedSet) {
            unnamedSet.add(resource);
            resource.register();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Resource resource) {
        SortedSet sortedSet = unnamedSet;
        synchronized (sortedSet) {
            if (unnamedSet.remove(resource)) {
                resource.deregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource remove(String name) {
        Resource ret;
        HashMap hashMap = resourceMap;
        synchronized (hashMap) {
            ret = (Resource)resourceMap.remove(name.toLowerCase());
        }
        if (ret != null) {
            ret.destroy();
            ret.deregister();
        }
        return ret;
    }

    static synchronized Resource forget(Resource resource) {
        if (resource.getName() != null) {
            return (Resource)resourceMap.remove(resource.getName());
        }
        if (unnamedSet.contains(resource)) {
            unnamedSet.remove(resource);
            return resource;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void manage() throws Exception {
        Resource res;
        int i;
        int n;
        if (!$assertionsDisabled && Thread.currentThread() != allocationThread) {
            throw new AssertionError((Object)"manage() may only be called in the main thread.");
        }
        ArrayList arrayList = destroying;
        synchronized (arrayList) {
            n = destroying.size();
            i = 0;
            while (i < n) {
                res = (Resource)destroying.get(i);
                Resources.deallocate(res);
                ++i;
            }
            destroying.clear();
        }
        arrayList = creating;
        synchronized (arrayList) {
            n = creating.size();
            i = 0;
            while (i < n) {
                res = (Resource)creating.get(i);
                Resources.allocate(res);
                ++i;
            }
            creating.clear();
        }
    }

    public static synchronized void save(OutputStream os) throws IOException {
        BufferedOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new BufferedOutputStream(os);
            oos = new ObjectOutputStream(bos);
            ArrayList named = new ArrayList(resourceMap.values());
            Collections.sort(named);
            oos.writeObject(named);
            oos.writeObject(unnamedSet);
            oos.flush();
            bos.flush();
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception exception) {}
            try {
                bos.close();
            }
            catch (Exception exception) {}
        }
    }

    public static synchronized void load(InputStream is) throws IOException, ClassNotFoundException {
        BufferedInputStream bis = new BufferedInputStream(is);
        ObjectInputStream ois = new ObjectInputStream(bis);
        ArrayList named = (ArrayList)ois.readObject();
        Iterator i = named.iterator();
        while (i.hasNext()) {
            Resource res = (Resource)i.next();
            Resources.put(res);
        }
        Set unnamed = (Set)ois.readObject();
        Iterator i2 = unnamed.iterator();
        while (i2.hasNext()) {
            Resource res = (Resource)i2.next();
            Resources.add(res);
        }
    }

    public static void clear() {
        Iterator<Object> i = resourceMap.values().iterator();
        while (i.hasNext()) {
            Resource res = (Resource)i.next();
            if (res == null) continue;
            if (res.isCreated()) {
                res.destroy();
            }
            res.deregister();
        }
        resourceMap.clear();
        i = unnamedSet.iterator();
        while (i.hasNext()) {
            ((Resource)i.next()).destroy();
        }
        unnamedSet.clear();
        System.gc();
    }

    public static void reset() {
        Iterator<Object> i = resourceMap.values().iterator();
        while (i.hasNext()) {
            Resource res = (Resource)i.next();
            if (res == null || !res.isCreated()) continue;
            res.destroy();
        }
        i = unnamedSet.iterator();
        while (i.hasNext()) {
            ((Resource)i.next()).destroy();
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void allocate(Resource res) throws Exception {
        Resource resource = res;
        synchronized (resource) {
            if (Thread.currentThread() == allocationThread) {
                try {
                    res.doCreate();
                }
                catch (Exception e) {
                    System.err.println("Failed to create resource " + res + " due to " + e);
                    throw e;
                }
                catch (Throwable t) {
                    throw new Exception("Failed to create resource " + res, t);
                }
                res.created = true;
                res.queued = false;
                res.notifyAll();
            } else {
                ArrayList arrayList = creating;
                synchronized (arrayList) {
                    creating.add(res);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deallocate(Resource res) {
        Resource resource = res;
        synchronized (resource) {
            if (Thread.currentThread() == allocationThread) {
                res.doDestroy();
                res.created = false;
                res.dying = false;
                res.notifyAll();
            } else {
                ArrayList arrayList = destroying;
                synchronized (arrayList) {
                    destroying.add(res);
                }
            }
        }
    }

    public static int getNumCreated() {
        return numCreated;
    }

    public static int getNumQueued() {
        return numQueued;
    }

    public static CreatingCallback getCreatingCallback() {
        return creatingCallback;
    }

    public static void setCreatingCallback(CreatingCallback creatingCallback) {
        Resources.creatingCallback = creatingCallback;
    }

    public static List list(Class clazz) {
        LinkedList ret = new LinkedList();
        Iterator i = resourceMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (!clazz.isAssignableFrom(entry.getValue().getClass())) continue;
            ret.add(entry.getValue());
        }
        return ret;
    }

    public static Thread getAllocationThread() {
        return allocationThread;
    }

    public static void setRunMode(boolean runMode) {
        Resources.runMode = runMode;
    }

    public static boolean isRunMode() {
        return runMode;
    }

    public static interface CreatingCallback {
        public void onCreating(Resource var1);
    }
}

