/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vector;

import java.io.Serializable;
import java.nio.FloatBuffer;
import org.lwjgl.util.vector.Matrix;
import org.lwjgl.util.vector.Vector3f;

public class Matrix3f
extends Matrix
implements Serializable {
    private static final long serialVersionUID = 1L;
    public float m00 = 1.0f;
    public float m01;
    public float m02;
    public float m10;
    public float m11 = 1.0f;
    public float m12;
    public float m20;
    public float m21;
    public float m22 = 1.0f;

    public Matrix3f load(Matrix3f src) {
        this.m00 = src.m00;
        this.m10 = src.m10;
        this.m20 = src.m20;
        this.m01 = src.m01;
        this.m11 = src.m11;
        this.m21 = src.m21;
        this.m02 = src.m02;
        this.m12 = src.m12;
        this.m22 = src.m22;
        return this;
    }

    public Matrix load(FloatBuffer buf) {
        this.m00 = buf.get();
        this.m01 = buf.get();
        this.m02 = buf.get();
        this.m10 = buf.get();
        this.m11 = buf.get();
        this.m12 = buf.get();
        this.m20 = buf.get();
        this.m21 = buf.get();
        this.m22 = buf.get();
        return this;
    }

    public Matrix loadTranspose(FloatBuffer buf) {
        this.m00 = buf.get();
        this.m10 = buf.get();
        this.m20 = buf.get();
        this.m01 = buf.get();
        this.m11 = buf.get();
        this.m21 = buf.get();
        this.m02 = buf.get();
        this.m12 = buf.get();
        this.m22 = buf.get();
        return this;
    }

    public Matrix store(FloatBuffer buf) {
        buf.put(this.m00);
        buf.put(this.m01);
        buf.put(this.m02);
        buf.put(this.m10);
        buf.put(this.m11);
        buf.put(this.m12);
        buf.put(this.m20);
        buf.put(this.m21);
        buf.put(this.m22);
        return this;
    }

    public Matrix storeTranspose(FloatBuffer buf) {
        buf.put(this.m00);
        buf.put(this.m10);
        buf.put(this.m20);
        buf.put(this.m01);
        buf.put(this.m11);
        buf.put(this.m21);
        buf.put(this.m02);
        buf.put(this.m12);
        buf.put(this.m22);
        return this;
    }

    public static Matrix3f add(Matrix3f left, Matrix3f right, Matrix3f dest) {
        Matrix3f temp = null;
        if (dest == null) {
            dest = new Matrix3f();
        } else if (dest == left || dest == right) {
            temp = dest;
            dest = new Matrix3f();
        }
        dest.m00 = left.m00 + right.m00;
        dest.m01 = left.m01 + right.m01;
        dest.m02 = left.m02 + right.m02;
        dest.m10 = left.m10 + right.m10;
        dest.m11 = left.m11 + right.m11;
        dest.m12 = left.m12 + right.m12;
        dest.m20 = left.m20 + right.m20;
        dest.m21 = left.m21 + right.m21;
        dest.m22 = left.m22 + right.m22;
        if (temp != null) {
            temp.load(dest);
            return temp;
        }
        return dest;
    }

    public static Matrix3f sub(Matrix3f left, Matrix3f right, Matrix3f dest) {
        Matrix3f temp = null;
        if (dest == null) {
            dest = new Matrix3f();
        } else if (dest == left || dest == right) {
            temp = dest;
            dest = new Matrix3f();
        }
        dest.m00 = left.m00 - right.m00;
        dest.m01 = left.m01 - right.m01;
        dest.m02 = left.m02 - right.m02;
        dest.m10 = left.m10 - right.m10;
        dest.m11 = left.m11 - right.m11;
        dest.m12 = left.m12 - right.m12;
        dest.m20 = left.m20 - right.m20;
        dest.m21 = left.m21 - right.m21;
        dest.m22 = left.m22 - right.m22;
        if (temp != null) {
            temp.load(dest);
            return temp;
        }
        return dest;
    }

    public static Matrix3f mul(Matrix3f left, Matrix3f right, Matrix3f dest) {
        Matrix3f temp = null;
        if (dest == null) {
            dest = new Matrix3f();
        } else if (dest == left || dest == right) {
            temp = dest;
            dest = new Matrix3f();
        }
        dest.m00 = left.m00 * right.m00 + left.m10 * right.m01 + left.m20 * right.m02;
        dest.m01 = left.m01 * right.m00 + left.m11 * right.m01 + left.m21 * right.m02;
        dest.m02 = left.m02 * right.m00 + left.m12 * right.m01 + left.m22 * right.m02;
        dest.m10 = left.m00 * right.m10 + left.m10 * right.m11 + left.m20 * right.m12;
        dest.m11 = left.m01 * right.m10 + left.m11 * right.m11 + left.m21 * right.m12;
        dest.m12 = left.m02 * right.m10 + left.m12 * right.m11 + left.m22 * right.m12;
        dest.m20 = left.m00 * right.m20 + left.m10 * right.m21 + left.m20 * right.m22;
        dest.m21 = left.m01 * right.m20 + left.m11 * right.m21 + left.m21 * right.m22;
        dest.m22 = left.m02 * right.m20 + left.m12 * right.m21 + left.m22 * right.m22;
        if (temp != null) {
            temp.load(dest);
            return temp;
        }
        return dest;
    }

    public static Vector3f transform(Matrix3f left, Vector3f right, Vector3f dest) {
        Vector3f temp = null;
        if (dest == null) {
            dest = new Vector3f();
        } else if (dest == right) {
            temp = dest;
            dest = new Vector3f();
        }
        dest.x = left.m00 * right.x + left.m10 * right.y + left.m20 * right.z;
        dest.y = left.m01 * right.x + left.m11 * right.y + left.m21 * right.z;
        dest.z = left.m02 * right.x + left.m12 * right.y + left.m22 * right.z;
        if (temp != null) {
            temp.set(dest);
            return temp;
        }
        return dest;
    }

    public Matrix transpose() {
        float f = this.m10;
        this.m10 = this.m01;
        this.m01 = f;
        f = this.m20;
        this.m20 = this.m02;
        this.m02 = f;
        f = this.m21;
        this.m21 = this.m12;
        this.m12 = f;
        return this;
    }

    public Matrix3f transpose(Matrix3f dest) {
        if (dest == null) {
            dest = new Matrix3f();
        }
        if (this == dest) {
            this.transpose();
        } else {
            dest.m00 = this.m00;
            dest.m01 = this.m10;
            dest.m02 = this.m20;
            dest.m10 = this.m01;
            dest.m11 = this.m11;
            dest.m12 = this.m21;
            dest.m20 = this.m02;
            dest.m21 = this.m12;
            dest.m22 = this.m22;
        }
        return dest;
    }

    public float determinant() {
        float f = this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m01 * (this.m12 * this.m20 - this.m10 * this.m22) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20);
        return f;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m00).append(' ').append(this.m10).append(' ').append(this.m20).append(' ').append('\n');
        buf.append(this.m01).append(' ').append(this.m11).append(' ').append(this.m21).append(' ').append('\n');
        buf.append(this.m02).append(' ').append(this.m12).append(' ').append(this.m22).append(' ').append('\n');
        return buf.toString();
    }

    public Matrix invert() {
        float determinant = this.determinant();
        if (determinant != 0.0f) {
            float determinant_inv = 1.0f / determinant;
            float t00 = this.m11 * this.m22 - this.m12 * this.m21;
            float t01 = -this.m10 * this.m22 + this.m12 * this.m20;
            float t02 = this.m10 * this.m21 - this.m11 * this.m20;
            float t10 = -this.m01 * this.m22 + this.m02 * this.m21;
            float t11 = this.m00 * this.m22 - this.m02 * this.m20;
            float t12 = -this.m00 * this.m21 + this.m01 * this.m20;
            float t20 = this.m01 * this.m12 - this.m02 * this.m11;
            float t21 = -this.m00 * this.m12 + this.m02 * this.m10;
            float t22 = this.m00 * this.m11 - this.m01 * this.m10;
            this.m00 = t00 * determinant_inv;
            this.m11 = t11 * determinant_inv;
            this.m22 = t22 * determinant_inv;
            this.m01 = t10 * determinant_inv;
            this.m10 = t01 * determinant_inv;
            this.m20 = t02 * determinant_inv;
            this.m02 = t20 * determinant_inv;
            this.m12 = t21 * determinant_inv;
            this.m21 = t12 * determinant_inv;
            return this;
        }
        return null;
    }

    public Matrix negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m02;
        this.m02 = -this.m01;
        this.m10 = -this.m10;
        this.m11 = -this.m12;
        this.m12 = -this.m11;
        this.m20 = -this.m20;
        this.m21 = -this.m22;
        this.m22 = -this.m21;
        return this;
    }

    public Matrix3f negate(Matrix3f dest) {
        if (dest == null) {
            dest = new Matrix3f();
        }
        dest.m00 = -this.m00;
        dest.m01 = -this.m02;
        dest.m02 = -this.m01;
        dest.m10 = -this.m10;
        dest.m11 = -this.m12;
        dest.m12 = -this.m11;
        dest.m20 = -this.m20;
        dest.m21 = -this.m22;
        dest.m22 = -this.m21;
        return dest;
    }

    public Matrix setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        return this;
    }

    public Matrix setZero() {
        this.m00 = 0.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 0.0f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 0.0f;
        return this;
    }
}

