/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.interpolators.ColorInterpolator;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.FPMath;
import net.puppygames.applet.Game;
import net.puppygames.applet.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.Tickable;
import net.puppygames.applet.effects.Emitter;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.WritableColor;

public class Particle
implements Tickable {
    private static final Color cachedColor = new Color();
    private static int maxParticles = 1024;
    private static int numParticles;
    private static int falloffCount;
    float x;
    float y;
    float angle;
    float velocity;
    float acceleration;
    float ax;
    float ay;
    float vx;
    float vy;
    int tick;
    int duration;
    int fadeDuration;
    ReadableColor startColor;
    ReadableColor endColor;
    boolean fading;
    boolean finished;
    boolean scaleIn;
    int scale = FPMath.ONE;
    int endScale = FPMath.ONE;
    Sprite sprite;
    AnimatedAppearance appearance;
    Emitter emitter;
    boolean floorSet;
    boolean ceilingSet;
    boolean leftWallSet;
    boolean rightWallSet;
    float floor;
    float ceiling;
    float leftWall;
    float rightWall;
    int layer = 1;

    public Particle(float x, float y, float angle, float velocity, float acceleration, int duration, int fadeDuration, ReadableColor startColor, ReadableColor endColor) {
        this.x = x;
        this.y = y;
        this.angle = angle;
        this.velocity = velocity;
        this.acceleration = acceleration;
        this.duration = duration;
        this.fadeDuration = fadeDuration;
        this.startColor = startColor;
        this.endColor = endColor;
    }

    public void setScaleIn(boolean scaleIn) {
        this.scaleIn = scaleIn;
    }

    public void setAppearance(AnimatedAppearance appearance) {
        this.appearance = appearance;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public void setAx(float ax) {
        this.ax = ax;
    }

    public void setAy(float ay) {
        this.ay = ay;
    }

    public void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    public void spawn(Screen screen) {
        if (this.emitter != null) {
            this.emitter.setLocation(this.x, this.y);
        }
        if (numParticles > maxParticles) {
            return;
        }
        if ((float)numParticles > (float)maxParticles * 0.75f ? ++falloffCount < 4 : ((float)numParticles > (float)maxParticles * 0.66f ? ++falloffCount < 3 : (float)numParticles > (float)maxParticles * 0.5f && ++falloffCount < 2)) {
            return;
        }
        falloffCount = 0;
        this.sprite = screen.allocateSprite(this);
        if (this.sprite != null) {
            if (this.appearance != null) {
                this.sprite.setAppearance(this.appearance);
            } else {
                this.sprite.setImage(Res.getParticleImage());
            }
            screen.addTickable(this);
            this.sprite.setLayer(this.layer);
            ++numParticles;
        }
    }

    public void remove() {
        if (this.sprite != null) {
            this.sprite.deallocate();
            this.sprite = null;
            --numParticles;
        }
        if (this.emitter != null) {
            this.emitter.remove();
            this.emitter = null;
        }
    }

    public void tick() {
        ++this.tick;
        float dx = this.velocity * (float)Math.cos(Math.toRadians(this.angle));
        float dy = this.velocity * (float)Math.sin(Math.toRadians(this.angle));
        this.velocity += this.acceleration;
        if (this.velocity <= 0.0f) {
            this.velocity = 0.0f;
            this.acceleration = 0.0f;
        }
        this.vx += this.ax;
        this.vy += this.ay;
        this.x += dx + this.vx;
        this.y += dy + this.vy;
        if (this.leftWallSet && this.x < this.leftWall) {
            this.vx = -this.vx;
            dx = -dx;
            this.angle = (float)Math.atan2(dy + this.vy, dx + this.vx);
            this.x = this.leftWall + (this.leftWall - this.x);
        } else if (this.rightWallSet && this.x > this.rightWall) {
            this.vx = -this.vx;
            dx = -dx;
            this.angle = (float)Math.atan2(dy + this.vy, dx + this.vx);
            this.x = this.rightWall - (this.x - this.rightWall);
        }
        if (this.floorSet && this.y < this.floor) {
            this.vy = -this.vy;
            dy = -dy;
            this.angle = (float)Math.atan2(dy + this.vy, dx + this.vx);
            this.y = this.floor + (this.floor - this.y);
        } else if (this.ceilingSet && this.y > this.ceiling) {
            this.vy = -this.vy;
            dy = -dy;
            this.angle = (float)Math.atan2(dy + this.vy, dx + this.vx);
            this.y = this.ceiling - (this.y - this.ceiling);
        }
        if (this.emitter != null) {
            this.emitter.setLocation(this.x, this.y);
        }
        if (this.fading) {
            float ratio = (float)this.tick / (float)this.fadeDuration;
            cachedColor.setColor(this.endColor);
            cachedColor.setAlpha(255 - (int)((float)this.endColor.getAlpha() * ratio));
            if (this.endScale != FPMath.ONE) {
                this.sprite.setScale(LinearInterpolator.instance.interpolate(this.scale, this.endScale, FPMath.fpValue((float)ratio)));
            }
            if (this.tick == this.fadeDuration) {
                this.finished = true;
                this.tick = 0;
            }
        } else {
            float ratio = (float)this.tick / (float)this.duration;
            ColorInterpolator.interpolate((ReadableColor)this.startColor, (ReadableColor)this.endColor, (float)ratio, (Interpolator)LinearInterpolator.instance, (WritableColor)cachedColor);
            if (this.scaleIn) {
                this.sprite.setScale(LinearInterpolator.instance.interpolate(0, this.scale, FPMath.fpValue((float)ratio)));
            }
            if (this.tick >= this.duration) {
                this.fading = true;
                this.tick = 0;
            }
        }
        this.sprite.setColors((ReadableColor)cachedColor);
        this.sprite.setLocation((int)this.x, (int)this.y, 0);
    }

    public boolean isActive() {
        return this.x > 0.0f && this.y > 0.0f && this.x < (float)Game.getWidth() && this.y < (float)Game.getHeight() && this.sprite != null && !this.finished;
    }

    public void setCeiling(float ceiling) {
        this.ceiling = ceiling;
        this.ceilingSet = true;
        if (this.emitter != null) {
            this.emitter.setCeiling(ceiling);
        }
    }

    public void setFloor(float floor) {
        this.floor = floor;
        this.floorSet = true;
        if (this.emitter != null) {
            this.emitter.setFloor(floor);
        }
    }

    public void setLeftWall(float leftWall) {
        this.leftWall = leftWall;
        this.leftWallSet = true;
        if (this.emitter != null) {
            this.emitter.setLeftWall(leftWall);
        }
    }

    public void setRightWall(float rightWall) {
        this.rightWall = rightWall;
        this.rightWallSet = true;
        if (this.emitter != null) {
            this.emitter.setRightWall(rightWall);
        }
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setEndScale(int endScale) {
        this.endScale = endScale;
    }

    public static void setMaxParticles(int maxParticles) {
        Particle.maxParticles = maxParticles;
    }
}

