/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.openal.ALBuffer;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.Tickable;

public abstract class Effect
implements Tickable {
    private int delay = 1;
    private Screen screen;
    private ALBuffer sound;

    public boolean isStarted() {
        return this.delay == 0;
    }

    public void start() {
        this.delay = 0;
        if (this.sound != null) {
            Game.allocateSound(this.sound);
        }
        this.init();
    }

    public final void spawn(Screen screen) {
        this.screen = screen;
        if (this.isBackgroundEffect()) {
            screen.addBackgroundEffect(this);
        } else {
            screen.addForegroundEffect(this);
        }
        this.doSpawn();
    }

    protected Screen getScreen() {
        return this.screen;
    }

    protected void doSpawn() {
    }

    public final void setDelay(int delay) {
        this.delay = delay;
    }

    public final void tick() {
        if (this.delay > 0) {
            --this.delay;
            if (this.delay == 0) {
                this.start();
            }
        }
        if (this.delay == 0) {
            this.doTick();
        }
    }

    public final void setSound(ALBuffer sound) {
        this.sound = sound;
    }

    protected void init() {
    }

    protected abstract void doTick();

    public final void render() {
        if (this.delay == 0) {
            this.doRender();
        }
    }

    protected abstract void doRender();

    public void finish() {
        this.remove();
    }

    public final void remove() {
        if (this.isBackgroundEffect()) {
            this.screen.removeBackgroundEffect(this);
        } else {
            this.screen.removeForegroundEffect(this);
        }
        this.doRemove();
    }

    protected void doRemove() {
    }

    public boolean isBackgroundEffect() {
        return false;
    }
}

