/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.opengl.GL;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.SerializedSprite;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteEngine;
import com.shavenpuppy.jglib.sprites.StaticSpriteEngine;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.puppygames.applet.Area;
import net.puppygames.applet.Binding;
import net.puppygames.applet.Game;
import net.puppygames.applet.Tickable;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.w3c.dom.Element;

public abstract class Screen
extends Feature {
    public static final long serialVersionUID = 1L;
    private static final List screens;
    private static final int FADE_TIME = 15;
    private static final float START_DEPTH = -200.0f;
    private static final float END_DEPTH = 400.0f;
    private int maxSprites = 32;
    private List areas;
    private boolean mouseVisible;
    private boolean keyboardNavigation;
    private String music;
    private transient StaticSpriteEngine spriteEngine;
    private transient List backgroundEffects;
    private transient List foregroundEffects;
    private transient int timer;
    private transient int phase;
    private transient float alpha;
    private transient int mouseX;
    private transient int mouseY;
    private transient int oldMouseX;
    private transient int oldMouseY;
    private transient Map nameToArea;
    private transient boolean enabled;
    private transient List tickables;
    private transient Area focus;
    private transient boolean inited;
    private transient ALBuffer musicResource;
    private static final int CLOSED = 0;
    private static final int OPENING = 1;
    private static final int OPEN = 2;
    private static final int CLOSING = 3;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.puppygames.applet.Screen");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        screens = new ArrayList(4);
    }

    public Screen(String name) {
        super(name);
    }

    public final void setDefaultScreen() {
        SerializedSprite.setSpriteEngine((SpriteEngine)this.spriteEngine);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        List children = XMLUtil.getChildren((Element)element, (String)"area");
        this.areas = new ArrayList(children.size());
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Element child = (Element)i.next();
            Area area = new Area();
            area.load(child, loader);
            this.areas.add(area);
        }
    }

    protected final void doCreate() throws Exception {
        super.doCreate();
        if (!this.inited) {
            this.backgroundEffects = new ArrayList(4);
            this.foregroundEffects = new ArrayList(8);
            this.tickables = new ArrayList(256);
            this.spriteEngine = new StaticSpriteEngine(true, this.maxSprites, 1);
            this.spriteEngine.setLocked(true);
            this.spriteEngine.create();
            this.addTickable(new Tickable(){

                public void tick() {
                    Screen.this.spriteEngine.tick();
                }

                public void remove() {
                }

                public boolean isActive() {
                    return true;
                }

                public void spawn(Screen screen) {
                }
            });
            this.inited = true;
        }
        this.nameToArea = new HashMap();
        Iterator i = this.areas.iterator();
        while (i.hasNext()) {
            Area area = (Area)i.next();
            area.create();
            area.spawn(this);
            this.nameToArea.put(area.getID(), area);
        }
        this.doCreateScreen();
    }

    protected final void doDestroy() {
        super.doDestroy();
        Iterator i = this.areas.iterator();
        while (i.hasNext()) {
            Area area = (Area)i.next();
            area.destroy();
        }
        this.areas = null;
        this.doDestroyScreen();
    }

    protected void doCreateScreen() throws Exception {
    }

    protected void doDestroyScreen() {
    }

    public void requestFocus(Area area) {
        if (area == null) {
            this.setFocus(null);
        } else if (area.isFocusable()) {
            this.setFocus(area.getID());
        }
    }

    private void checkKeyboardNavigation() {
        if (this.focus == null) {
            this.mouseMoved();
        }
        String changeFocus = null;
        int count = 0;
        while (count < this.areas.size()) {
            if (Binding.isBindingDown("focus.left.binding") || Binding.isBindingDown("focus.left.binding.alt")) {
                if (this.focus == null) {
                    this.findFirstFocus();
                } else {
                    changeFocus = this.focus.getLeftFocus();
                }
            } else if (Binding.isBindingDown("focus.right.binding") || Binding.isBindingDown("focus.right.binding.alt")) {
                if (this.focus == null) {
                    this.findFirstFocus();
                } else {
                    changeFocus = this.focus.getRightFocus();
                }
            } else if (Binding.isBindingDown("focus.up.binding") || Binding.isBindingDown("focus.up.binding.alt")) {
                if (this.focus == null) {
                    this.findFirstFocus();
                } else {
                    changeFocus = this.focus.getUpFocus();
                }
            } else if (Binding.isBindingDown("focus.down.binding") || Binding.isBindingDown("focus.down.binding.alt")) {
                if (this.focus == null) {
                    this.findFirstFocus();
                } else {
                    changeFocus = this.focus.getDownFocus();
                }
            } else if (Game.wasKeyPressed(15)) {
                if (this.focus == null) {
                    this.findFirstFocus();
                } else {
                    changeFocus = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? this.focus.getPrevFocus() : this.focus.getNextFocus();
                }
            } else {
                return;
            }
            if (changeFocus == null) {
                return;
            }
            this.setFocus(changeFocus);
            if (this.focus == null || !this.focus.isFocused()) continue;
            return;
        }
    }

    private void findFirstFocus() {
        Area area;
        Iterator i = this.areas.iterator();
        while (i.hasNext()) {
            area = (Area)i.next();
            if (!area.isFocusable() || !area.isDefaultFocus()) continue;
            this.focus = area;
            return;
        }
        i = this.areas.iterator();
        while (i.hasNext()) {
            area = (Area)i.next();
            if (!area.isFocusable()) continue;
            this.focus = area;
            return;
        }
        this.focus = null;
    }

    private void setFocus(String areaName) {
        this.focus = this.getArea(areaName);
    }

    public final void tick() {
        this.oldMouseX = this.mouseX;
        this.oldMouseY = this.mouseY;
        this.mouseX = (int)((float)Game.getWidth() * (float)(Mouse.getX() - Game.getViewPort().getX()) / (float)Game.getViewPort().getWidth());
        this.mouseY = (int)((float)Game.getHeight() * (float)(Mouse.getY() - Game.getViewPort().getY()) / (float)Game.getViewPort().getHeight());
        switch (this.phase) {
            case 1: {
                if (++this.timer < 15) break;
                this.phase = 2;
                this.timer = 0;
            }
            case 2: {
                int i;
                if (this.enabled) {
                    if (this.keyboardNavigation) {
                        this.checkKeyboardNavigation();
                    }
                    i = 0;
                    while (i < this.areas.size()) {
                        Area area = (Area)this.areas.get(i);
                        area.tick();
                        ++i;
                    }
                }
                this.doTick();
                i = 0;
                while (i < this.tickables.size()) {
                    Tickable tickable = (Tickable)this.tickables.get(i);
                    if (tickable.isActive()) {
                        tickable.tick();
                    }
                    if (tickable.isActive()) {
                        ++i;
                        continue;
                    }
                    int n = this.tickables.size() - 1;
                    this.tickables.set(i, this.tickables.get(n));
                    this.tickables.remove(n);
                    tickable.remove();
                }
                while (Keyboard.next()) {
                }
                while (Mouse.next()) {
                }
                while (Controllers.next()) {
                }
                break;
            }
            case 3: {
                if (++this.timer < 15) break;
                this.phase = 0;
                this.removeAllTickables();
                this.doCleanup();
                break;
            }
            case 0: {
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    public boolean mouseMoved() {
        return this.mouseX != this.oldMouseX || this.mouseY != this.oldMouseY;
    }

    protected void doTick() {
    }

    public final void addTickable(Tickable tickable) {
        this.tickables.add(tickable);
    }

    public final void addBackgroundEffect(Effect effect) {
        this.backgroundEffects.add(effect);
        this.addTickable(effect);
    }

    public final void addForegroundEffect(Effect effect) {
        this.foregroundEffects.add(effect);
        this.addTickable(effect);
    }

    public final void removeBackgroundEffect(Effect effect) {
        this.backgroundEffects.remove(effect);
    }

    public final void removeForegroundEffect(Effect effect) {
        this.foregroundEffects.remove(effect);
    }

    public final void removeAllTickables() {
        int n = this.tickables.size();
        int i = 0;
        while (i < n) {
            Tickable tickable = (Tickable)this.tickables.get(i);
            tickable.remove();
            if (tickable.isActive()) {
                ++i;
                continue;
            }
            this.tickables.set(i, this.tickables.get(--n));
            this.tickables.remove(n);
        }
    }

    protected void onClicked(String id) {
    }

    protected void onHover(String id, boolean on) {
    }

    private boolean isActive() {
        return this.phase != 0;
    }

    public final void close() {
        if (this.isClosing() || this.isClosed()) {
            return;
        }
        this.phase = 3;
        this.timer = 0;
        this.focus = null;
        this.onClose();
    }

    protected void onClose() {
    }

    public final void open() {
        if (this.isOpen() || this.isOpening()) {
            return;
        }
        if (screens.size() > 0) {
            Screen topmost = (Screen)((Object)screens.get(screens.size() - 1));
            if (topmost != this) {
                topmost.close();
            } else {
                topmost.removeAllTickables();
                topmost.doCleanup();
            }
        }
        if (screens.contains((Object)this)) {
            screens.remove((Object)this);
        }
        screens.add(this);
        this.phase = 1;
        this.enabled = true;
        this.timer = 0;
        this.focus = null;
        if (this.musicResource != null) {
            Game.playMusic(this.musicResource, 60);
        }
        this.onOpen();
    }

    protected void onOpen() {
    }

    protected void doCleanup() {
    }

    public final void render() {
        float depth;
        float alpha;
        switch (this.phase) {
            case 3: {
                alpha = LinearInterpolator.instance.interpolate(1.0f, 0.0f, (float)this.timer / 15.0f);
                depth = LinearInterpolator.instance.interpolate(0.0f, 400.0f, (float)this.timer / 15.0f);
                break;
            }
            case 1: {
                alpha = LinearInterpolator.instance.interpolate(0.0f, 1.0f, (float)this.timer / 15.0f);
                depth = LinearInterpolator.instance.interpolate(-200.0f, 0.0f, (float)this.timer / 15.0f);
                break;
            }
            case 2: {
                alpha = 1.0f;
                depth = 0.0f;
                break;
            }
            default: {
                float alpha2 = 0.0f;
                float depth2 = 0.0f;
                return;
            }
        }
        this.preRender();
        GL.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GL.glPushMatrix();
        GL.glTranslatef((float)0.0f, (float)0.0f, (float)depth);
        this.renderBackground();
        this.renderEffects(this.backgroundEffects);
        this.spriteEngine.setAlpha(alpha);
        this.spriteEngine.render();
        Iterator i = this.areas.iterator();
        while (i.hasNext()) {
            Area area = (Area)i.next();
            area.render();
        }
        this.renderForeground();
        this.renderEffects(this.foregroundEffects);
        this.postRender();
        GL.glPopMatrix();
    }

    private void renderEffects(List effects) {
        int n = effects.size();
        int i = 0;
        while (i < n) {
            Effect effect = (Effect)effects.get(i);
            effect.render();
            ++i;
        }
    }

    protected void renderBackground() {
    }

    protected void renderForeground() {
    }

    protected void preRender() {
    }

    protected void postRender() {
    }

    public final Sprite allocateSprite(Object owner) {
        return this.spriteEngine.allocate(owner);
    }

    public static void tickAllScreens() {
        int i = 0;
        while (i < screens.size()) {
            Screen screen = (Screen)((Object)screens.get(i));
            screen.tick();
            if (screen.isActive()) {
                ++i;
                continue;
            }
            screens.remove(i);
        }
    }

    public static void renderAllScreens() {
        int i = 0;
        while (i < screens.size()) {
            Screen screen = (Screen)((Object)screens.get(i));
            screen.render();
            ++i;
        }
    }

    public static final boolean isMouseVisible() {
        if (screens.size() > 0) {
            Screen topmost = (Screen)((Object)screens.get(screens.size() - 1));
            return topmost.mouseVisible;
        }
        return true;
    }

    protected final float getAlpha() {
        return this.alpha;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public Area getArea(String name) {
        return (Area)this.nameToArea.get(name);
    }

    protected final boolean isOpening() {
        return this.phase == 1;
    }

    protected final boolean isClosing() {
        return this.phase == 3;
    }

    protected final boolean isClosed() {
        return this.phase == 0;
    }

    protected final boolean isOpen() {
        return this.phase == 2;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
        Iterator i = this.areas.iterator();
        while (i.hasNext()) {
            Area area = (Area)i.next();
            area.setEnabled(enabled);
        }
    }

    public final void setKeyboardNavigationEnabled(boolean keyboardNavigation) {
        this.keyboardNavigation = keyboardNavigation;
    }

    public final boolean isKeyboardNavigationEnabled() {
        return this.keyboardNavigation;
    }

    public final void nextFocus() {
    }

    public final void prevFocus() {
    }

    public Area getFocus() {
        return this.focus;
    }

    public void setEnabled(String area, boolean enabled) {
        Area a = this.getArea(area);
        if (a == null) {
            return;
        }
        a.setEnabled(enabled);
    }

    public void setVisible(String area, boolean visible) {
        Area a = this.getArea(area);
        if (a == null) {
            return;
        }
        a.setVisible(visible);
    }

    public void setGroupEnabled(String group, boolean enabled) {
        int n = this.areas.size();
        int i = 0;
        while (i < n) {
            Area area = (Area)this.areas.get(i);
            if (area.isInGroup(group)) {
                area.setEnabled(enabled);
            }
            ++i;
        }
    }

    public void setGroupVisible(String group, boolean visible) {
        int n = this.areas.size();
        int i = 0;
        while (i < n) {
            Area area = (Area)this.areas.get(i);
            if (area.isInGroup(group)) {
                area.setVisible(visible);
            }
            ++i;
        }
    }

    public void setGroupAlpha(String group, int alpha) {
        int n = this.areas.size();
        int i = 0;
        while (i < n) {
            Area area = (Area)this.areas.get(i);
            if (area.isInGroup(group)) {
                area.setAlpha(alpha);
            }
            ++i;
        }
    }

    public static Screen getTopScreen() {
        if (screens.size() == 0) {
            return null;
        }
        return (Screen)((Object)screens.get(screens.size() - 1));
    }
}

