/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import com.shavenpuppy.jglib.sprites.Style;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.GL11;

final class TextureRun {
    private static GLBaseTexture lastRenderedTexture;
    private static Style lastRenderedStyle;
    GLBaseTexture texture;
    Style style;
    int offset;
    int spritesToRender;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.sprites.TextureRun");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    TextureRun() {
    }

    void init(GLBaseTexture texture, Style style, int offset) {
        this.texture = texture;
        if (!$assertionsDisabled && texture == null) {
            throw new AssertionError();
        }
        this.style = style;
        if (!$assertionsDisabled && style == null) {
            throw new AssertionError();
        }
        this.offset = offset;
        this.spritesToRender = 0;
    }

    void add() {
        ++this.spritesToRender;
    }

    public void preRender() {
        if (this.texture != lastRenderedTexture) {
            this.texture.render();
            lastRenderedTexture = this.texture;
        }
        if (this.style != lastRenderedStyle) {
            if (lastRenderedStyle != null) {
                lastRenderedStyle.resetState();
            }
            this.style.setupState();
            lastRenderedStyle = this.style;
        }
    }

    void render() {
        this.preRender();
        GL11.glDrawArrays((int)7, (int)(this.offset << 2), (int)(this.spritesToRender << 2));
    }

    void drawRangeElements(ShortBuffer indices) {
        this.preRender();
        ShortBuffer runIndices = indices.slice();
        int startIndex = this.offset * 4;
        runIndices.position(startIndex);
        runIndices.limit(startIndex + this.spritesToRender * 4);
        GL11.glDrawElements((int)7, (ShortBuffer)runIndices);
    }

    void done() {
        if (lastRenderedStyle != null) {
            lastRenderedStyle.resetState();
        }
        lastRenderedStyle = null;
        lastRenderedTexture = null;
    }
}

