/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sound;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.openal.ALStream;
import com.shavenpuppy.jglib.openal.ALStreamInstance;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.util.PriorityPool;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.lwjgl.openal.OpenALException;

public class SoundPlayer
extends Resource {
    public static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private PriorityPool priorityPool;
    private final int sources;
    private transient SoundEffect[] fx;
    private transient List streams;
    private transient StreamThread streamThread;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.sound.SoundPlayer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public SoundPlayer(int sources) {
        this.sources = sources;
    }

    public void play() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError();
        }
        this.priorityPool.tick();
    }

    protected void doCreate() throws Exception {
        ArrayList<SoundEffect> tfx = new ArrayList<SoundEffect>(this.sources);
        try {
            int i = 0;
            while (i < this.sources) {
                SoundEffect se = new SoundEffect(this);
                se.source.create();
                tfx.add(se);
                ++i;
            }
        }
        catch (OpenALException openALException) {
            // empty catch block
        }
        this.fx = new SoundEffect[tfx.size()];
        tfx.toArray(this.fx);
        this.streams = new LinkedList();
        this.priorityPool = new PriorityPool(this.fx);
        this.streamThread = new StreamThread();
        this.streamThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDestroy() {
        this.priorityPool.reset();
        this.priorityPool = null;
        int i = 0;
        while (i < this.fx.length) {
            this.fx[i].source.destroy();
            this.fx[i] = null;
            ++i;
        }
        List list = this.streams;
        synchronized (list) {
            this.streams = null;
        }
        this.streamThread.finish();
        this.streamThread = null;
    }

    public SoundEffect allocate(ALBuffer buf, Object owner) {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError();
        }
        SoundEffect ret = (SoundEffect)this.priorityPool.allocate(buf.getPriority(), owner);
        if (ret != null) {
            ret.init(buf);
        }
        return ret;
    }

    public SoundEffect allocate(ALStream buf, Object owner) {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError();
        }
        SoundEffect ret = (SoundEffect)this.priorityPool.allocate(buf.getPriority(), owner);
        if (ret != null) {
            try {
                ret.init(buf);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                ret.deactivate();
                ret = null;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerStream(ALStreamInstance stream) {
        List list = this.streams;
        synchronized (list) {
            if (!this.streams.contains(stream)) {
                this.streams.add(stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregisterStream(ALStreamInstance stream) {
        List list = this.streams;
        synchronized (list) {
            this.streams.remove(stream);
        }
    }

    private class StreamThread
    extends Thread {
        private boolean finished;

        StreamThread() {
            super("Stream Thread");
            this.setPriority(6);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.finished) {
                List list = SoundPlayer.this.streams;
                synchronized (list) {
                    Iterator i = SoundPlayer.this.streams.iterator();
                    while (i.hasNext()) {
                        ALStreamInstance stream = (ALStreamInstance)i.next();
                        try {
                            if (!stream.isCreated()) continue;
                            stream.tick();
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        void finish() {
            this.finished = true;
        }
    }
}

