/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl.nvidia;

import com.shavenpuppy.jglib.Memory;
import com.shavenpuppy.jglib.Resource;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.NVVertexArrayRange;

class NvidiaMemory
extends Resource {
    final String name;
    final int size;
    ByteBuffer memoryBuffer;
    final float readFrequency;
    final float writeFrequency;
    final float priority;
    boolean reserved;

    NvidiaMemory(String name, int size, float readFrequency, float writeFrequency, float priority) {
        this.name = name;
        this.size = size;
        this.readFrequency = readFrequency;
        this.writeFrequency = writeFrequency;
        this.priority = priority;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doCreate() throws Exception {
        super.doCreate();
        if (this.size <= 0) {
            return;
        }
        if (GLContext.getCapabilities().GL_NV_vertex_array_range || GLContext.getCapabilities().GL_NV_vertex_array_range2) {
            String osName = System.getProperty("os.name", "");
            if (osName.startsWith("Win")) {
                this.memoryBuffer = NVVertexArrayRange.glAllocateMemoryNV((int)this.size, (float)this.readFrequency, (float)this.writeFrequency, (float)this.priority);
            } else {
                if (!osName.startsWith("Lin")) {
                    System.out.println("Unsupported platform for Nvidia ram.");
                    this.memoryBuffer = null;
                    return;
                }
                this.memoryBuffer = NVVertexArrayRange.glAllocateMemoryNV((int)this.size, (float)this.readFrequency, (float)this.writeFrequency, (float)this.priority);
            }
        } else {
            this.memoryBuffer = null;
        }
        if (this.memoryBuffer != null) {
            this.reserved = true;
        } else {
            System.out.println("Failed to reserve Nvidia ram.");
            this.memoryBuffer = BufferUtils.createByteBuffer((int)this.size);
            this.reserved = false;
        }
        Memory.init(this.name, this.memoryBuffer);
    }

    protected void doDestroy() {
        super.doDestroy();
        Memory.cleanup(this.name);
        if (this.reserved) {
            NVVertexArrayRange.glFreeMemoryNV((ByteBuffer)this.memoryBuffer);
            this.reserved = false;
        }
        this.memoryBuffer = null;
    }

    boolean isReserved() {
        return this.reserved;
    }
}

