/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.openal;

import com.shavenpuppy.jglib.openal.AL;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.openal.ALBufferID;
import com.shavenpuppy.jglib.openal.ALResource;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.OpenALException;
import org.lwjgl.util.vector.Vector3f;

public class ALSource
extends ALResource {
    public static final long serialVersionUID = 1L;
    private static ArrayList createdSources;
    private transient int source;
    private transient ALBufferID attachedBuffer;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.openal.ALSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        createdSources = new ArrayList(8);
    }

    static synchronized void unattach(ALBuffer buffer) {
        int i = 0;
        while (i < createdSources.size()) {
            ALSource s = (ALSource)createdSources.get(i);
            if (s.attachedBuffer == buffer) {
                s.stop();
                s.unattach();
            }
            ++i;
        }
    }

    public void play() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        AL10.alSourcePlay((int)this.source);
    }

    public void pause() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        AL10.alSourcePause((int)this.source);
    }

    public void stop() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        AL10.alSourceStop((int)this.source);
    }

    public void rewind() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        AL10.alSourceRewind((int)this.source);
    }

    public void set(int property, float value) {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        AL10.alSourcef((int)this.source, (int)property, (float)value);
    }

    public void set(int property, float x, float y, float z) {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        AL10.alSource3f((int)this.source, (int)property, (float)x, (float)y, (float)z);
    }

    public void set(int property, int value) {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        AL10.alSourcei((int)this.source, (int)property, (int)value);
    }

    protected void doALCreate() {
        if (!org.lwjgl.openal.AL.isCreated()) {
            return;
        }
        AL.scratch.ints.clear().limit(1);
        AL10.alGenSources((IntBuffer)AL.scratch.ints);
        this.source = AL.scratch.ints.get(0);
        if (!$assertionsDisabled && this.source <= 0) {
            throw new AssertionError();
        }
        createdSources.add(this);
    }

    protected void doALDestroy() {
        if (this.source != 0) {
            this.unattach();
            AL.scratch.ints.clear().limit(1);
            AL.scratch.ints.put(0, this.source);
            AL10.alDeleteSources((IntBuffer)AL.scratch.ints);
            createdSources.remove(this);
        }
    }

    public int getSourceID() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        return this.source;
    }

    public void attach(ALBufferID buffer) {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        try {
            this.unattach();
            this.set(4105, buffer.getBufferID());
            this.attachedBuffer = buffer;
        }
        catch (OpenALException e) {
            System.err.println("Failed: " + buffer.getBufferID() + " source: " + this.source);
            throw e;
        }
        if (buffer.isLooped()) {
            this.set(4103, 1);
        } else {
            this.set(4103, 0);
        }
    }

    public void queue(ALBufferID buffer) {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        AL.scratch.ints.clear();
        AL.scratch.ints.put(buffer.getBufferID());
        AL.scratch.ints.flip();
        if (this.attachedBuffer != null) {
            this.attachedBuffer = null;
            this.stop();
        }
        try {
            AL10.alSourceQueueBuffers((int)this.source, (IntBuffer)AL.scratch.ints);
        }
        catch (OpenALException e) {
            System.out.println("Failed to queue " + buffer + " on " + this + " [" + AL.scratch.ints.position() + "," + AL.scratch.ints.limit() + "," + AL.scratch.ints.get(0) + "]");
            throw e;
        }
        this.set(4103, 0);
    }

    public int dequeue() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        AL.scratch.ints.clear();
        AL.scratch.ints.limit(1);
        AL10.alSourceUnqueueBuffers((int)this.source, (IntBuffer)AL.scratch.ints);
        return AL.scratch.ints.get(0);
    }

    public void unattach() {
        this.stop();
        if (this.attachedBuffer != null) {
            this.set(4105, 0);
            this.attachedBuffer = null;
        }
        while (this.getInt(4118) > 0 || this.getInt(4117) > 0) {
            this.dequeue();
        }
    }

    public void setLooped(boolean looped) {
        this.set(4103, looped ? 1 : 0);
    }

    public String toString() {
        return "ALSource[" + this.source + "]";
    }

    public int getInt(int param) {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        return AL10.alGetSourcei((int)this.source, (int)param);
    }

    public float getFloat(int param) {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        return AL10.alGetSourcef((int)this.source, (int)param);
    }

    public Vector3f getFloats(int param, Vector3f ret) {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError((Object)(this + " is not created yet"));
        }
        AL.scratch.floats.clear();
        AL10.alGetSource((int)this.source, (int)param, (FloatBuffer)AL.scratch.floats);
        if (ret == null) {
            ret = new Vector3f();
        }
        ret.x = AL.scratch.floats.get(0);
        ret.y = AL.scratch.floats.get(1);
        ret.z = AL.scratch.floats.get(2);
        return ret;
    }
}

