/*
 * Decompiled with CFR 0.152.
 */
package invaders.behaviours;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.util.Util;
import invaders.GameScreen;
import invaders.Gidrah;
import invaders.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Effect;
import net.puppygames.applet.effects.Emitter;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;

public class AlienLaserEffect
extends Effect {
    private Gidrah gidrah;
    private float width;
    private float x;
    private float y;
    private float tx;
    private float ty;
    private Color color;
    private int duration;
    private int tick;
    private boolean visible;

    public AlienLaserEffect(float width, Color color, int duration, Gidrah gidrah) {
        this.width = width;
        this.color = color;
        this.duration = duration;
        this.gidrah = gidrah;
    }

    protected void doTick() {
        ++this.tick;
        this.visible = Util.random((int)0, (int)3) != 0;
        this.x = this.gidrah.getX();
        this.y = this.gidrah.getY();
        if (this.visible) {
            float r;
            float px = GameScreen.getPlayer().getX();
            if (this.x >= px - (r = GameScreen.getPlayer().getRadius()) && this.x <= px + r) {
                GameScreen.getPlayer().onCollisionWithAlienLaser(this);
                this.ty = 27.0f;
            } else {
                this.ty = 19.0f;
            }
            this.tx = this.x;
            Emitter e = Res.getAlienLaserEmitter().spawn((Screen)GameScreen.getInstance());
            e.setLocation(this.tx, this.ty);
            e.setFloor(19.0f);
        }
    }

    protected void doRender() {
        if (!this.visible) {
            return;
        }
        float ratio = LinearInterpolator.instance.interpolate(1.0f, 0.0f, (float)this.tick / (float)this.duration);
        GL11.glColor4ub((byte)this.color.getRedByte(), (byte)this.color.getGreenByte(), (byte)this.color.getBlueByte(), (byte)((byte)((float)this.color.getAlpha() * ratio)));
        GL11.glLineWidth((float)this.width);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glBegin((int)1);
        GL11.glVertex2f((float)this.x, (float)this.y);
        GL11.glVertex2f((float)this.tx, (float)this.ty);
        GL11.glEnd();
        GL11.glLineWidth((float)1.0f);
    }

    public boolean isActive() {
        return this.gidrah.isActive() && this.tick < this.duration;
    }
}

