/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import com.shavenpuppy.jglib.resources.Range;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.opengl.GL11;

public class ExplosionEffect
extends Effect {
    private float maxRadius;
    private int duration;
    private int fadeDuration;
    private int tick;
    private GLBaseTexture texture;
    private float x;
    private float y;
    private Interpolator interpolator;
    private float outerRadius;
    private float innerRadius;
    private Range angle;

    public ExplosionEffect(float radius, int duration, int fadeDuration, GLBaseTexture texture, Interpolator interpolator, Range angle) {
        this.maxRadius = radius;
        this.duration = duration;
        this.fadeDuration = fadeDuration;
        this.texture = texture;
        this.interpolator = interpolator;
        this.angle = angle == null ? new Range(0.0f, 360.0f) : angle;
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    protected void doTick() {
        ++this.tick;
        this.outerRadius = this.interpolator.interpolate(0.0f, this.maxRadius, (float)this.tick / (float)this.duration);
        this.innerRadius = this.interpolator.interpolate(0.0f, this.maxRadius, (float)(this.tick - this.duration) / (float)this.fadeDuration);
    }

    public float getRadius() {
        return this.outerRadius;
    }

    protected void doRender() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GL11.glBlendFunc((int)770, (int)1);
        this.texture.render();
        GL11.glBegin((int)5);
        float alpha = LinearInterpolator.instance.interpolate(1.0f, 0.0f, (float)(this.tick - this.duration) / (float)(this.duration + this.fadeDuration));
        float i = this.angle.getMin();
        while (i <= this.angle.getMax()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
            GL11.glTexCoord2f((float)i, (float)1.0f);
            GL11.glVertex2f((float)(this.x + (float)Math.cos(Math.toRadians(i)) * this.innerRadius), (float)(this.y + (float)Math.sin(Math.toRadians(i)) * this.innerRadius));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            GL11.glTexCoord2f((float)i, (float)0.0f);
            GL11.glVertex2f((float)(this.x + (float)Math.cos(Math.toRadians(i)) * this.outerRadius), (float)(this.y + (float)Math.sin(Math.toRadians(i)) * this.outerRadius));
            i += 10.0f;
        }
        GL11.glEnd();
    }

    public boolean isActive() {
        return this.tick < this.duration + this.fadeDuration;
    }

    public boolean isExploding() {
        return this.tick < this.duration;
    }
}

