/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.model.renderer;

import org.lwjgl.opengl.GL11;
import org.lwjgl.util.model.renderer.AnimationEventListener;
import org.lwjgl.util.model.renderer.ModelRenderer;
import org.lwjgl.util.vector.Vector3f;

public class Sprite3D
extends ModelRenderer {
    private final Vector3f position = new Vector3f();
    private final Vector3f axis = new Vector3f();
    private float angle;
    private static final String ANIM_HIDE = "hide";
    private static final String ANIM_REWIND = "rewind";
    private static final String ANIM_GOTO = "goto ";

    public Sprite3D() {
        this.addAnimationEventListener(new AnimationEventListener(){

            public void receiveAnimationEvent(ModelRenderer src, String action) {
                if (action.equals(Sprite3D.ANIM_HIDE)) {
                    Sprite3D.this.setVisible(false);
                } else if (action.equals(Sprite3D.ANIM_REWIND)) {
                    Sprite3D.this.rewind();
                } else if (action.startsWith(Sprite3D.ANIM_GOTO)) {
                    Sprite3D.this.setAnimation(action.substring(Sprite3D.ANIM_GOTO.length()));
                }
            }
        });
    }

    protected void renderFrame() {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.position.getX(), (float)this.position.getY(), (float)this.position.getY());
        super.renderFrame();
        GL11.glPopMatrix();
    }

    public Vector3f getPosition() {
        return this.position;
    }
}

