/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.model.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.Renderable;
import org.lwjgl.util.Timer;
import org.lwjgl.util.model.Frame;
import org.lwjgl.util.model.Model;
import org.lwjgl.util.model.renderer.AnimationEventListener;
import org.lwjgl.util.model.renderer.FrameProcessor;

public class ModelRenderer
implements Renderable {
    private static final Map materials = new HashMap();
    private Model model;
    private FrameProcessor processor;
    private List listeners;
    private Renderable material;
    private Frame[] frame;
    private final Timer timer = new Timer();
    private Frame currentFrame;
    private boolean visible = true;

    public void setModel(Model model) {
        if (this.model == model) {
            return;
        }
        this.model = model;
        this.material = (Renderable)materials.get(model.getMaterial());
        this.frame = null;
    }

    public Model getModel() {
        return this.model;
    }

    public void setAnimation(String animation) {
        if (this.model == null) {
            return;
        }
        this.frame = this.model.getAnimation(animation);
        this.timer.reset();
    }

    public void update() {
        if (this.model == null || this.frame == null || this.processor == null) {
            return;
        }
        Frame frame = this.findFrame();
        if (frame != this.currentFrame) {
            this.currentFrame = frame;
            this.processFrame();
            if (this.currentFrame.getAction() != null) {
                this.fireAnimationEvent(this.currentFrame.getAction());
            }
        }
    }

    public void render() {
        if (this.model == null || this.frame == null || this.processor == null || !this.visible) {
            return;
        }
        if (this.material != null) {
            this.material.render();
        }
        this.renderFrame();
    }

    private Frame findFrame() {
        float time = this.timer.getTime();
        int i = 0;
        int j = this.frame.length - 1;
        while (i <= j) {
            int k = i + j >> 1;
            Frame f = this.frame[k];
            if (f.getTime() == time) {
                return f;
            }
            if (f.getTime() < time) {
                i = k + 1;
                continue;
            }
            j = k - 1;
        }
        return this.frame[i + 1];
    }

    protected void processFrame() {
        this.processor.process(this.model, this.currentFrame);
    }

    protected void renderFrame() {
        this.processor.render();
    }

    public static void putMaterial(String name, Renderable renderable) {
        materials.put(name, renderable);
    }

    public static Renderable removeMaterial(String name) {
        return (Renderable)materials.remove(name);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isPaused() {
        return this.timer.isPaused();
    }

    public void pause() {
        this.timer.pause();
    }

    public void rewind() {
        this.timer.reset();
    }

    public void resume() {
        this.timer.resume();
    }

    public FrameProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(FrameProcessor processor) {
        this.processor = processor;
    }

    public void addAnimationEventListener(AnimationEventListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeAnimationEventListener(AnimationEventListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.size() == 0) {
            this.listeners = null;
        }
    }

    protected void fireAnimationEvent(String action) {
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.size();
        int i = 0;
        while (i < n) {
            AnimationEventListener listener = (AnimationEventListener)this.listeners.get(i);
            listener.receiveAnimationEvent(this, action);
            ++i;
        }
    }
}

