/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.lwjgl.LWJGLUtil;

public class WaveData {
    public final ByteBuffer data;
    public final int format;
    public final int samplerate;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lwjgl.util.WaveData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private WaveData(ByteBuffer data, int format, int samplerate) {
        this.data = data;
        this.format = format;
        this.samplerate = samplerate;
    }

    public void dispose() {
        this.data.clear();
    }

    public static WaveData create(URL path) {
        try {
            return WaveData.create(AudioSystem.getAudioInputStream(new BufferedInputStream(path.openStream())));
        }
        catch (Exception e) {
            LWJGLUtil.log((String)("Unable to create from: " + path));
            e.printStackTrace();
            return null;
        }
    }

    public static WaveData create(String path) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lwjgl.util.WaveData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return WaveData.create(clazz.getClassLoader().getResource(path));
    }

    public static WaveData create(InputStream is) {
        try {
            return WaveData.create(AudioSystem.getAudioInputStream(is));
        }
        catch (Exception e) {
            LWJGLUtil.log((String)"Unable to create from inputstream");
            e.printStackTrace();
            return null;
        }
    }

    public static WaveData create(byte[] buffer) {
        try {
            return WaveData.create(AudioSystem.getAudioInputStream(new BufferedInputStream(new ByteArrayInputStream(buffer))));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static WaveData create(ByteBuffer buffer) {
        try {
            byte[] bytes = null;
            if (buffer.hasArray()) {
                bytes = buffer.array();
            } else {
                bytes = new byte[buffer.capacity()];
                buffer.get(bytes);
            }
            return WaveData.create(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static WaveData create(AudioInputStream ais) {
        AudioFormat audioformat = ais.getFormat();
        int channels = 0;
        if (audioformat.getChannels() == 1) {
            if (audioformat.getSampleSizeInBits() == 8) {
                channels = 4352;
            } else if (audioformat.getSampleSizeInBits() == 16) {
                channels = 4353;
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Illegal sample size");
            }
        } else if (audioformat.getChannels() == 2) {
            if (audioformat.getSampleSizeInBits() == 8) {
                channels = 4354;
            } else if (audioformat.getSampleSizeInBits() == 16) {
                channels = 4355;
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Illegal sample size");
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Only mono or stereo is supported");
        }
        byte[] buf = new byte[audioformat.getChannels() * (int)ais.getFrameLength() * audioformat.getSampleSizeInBits() / 8];
        int read = 0;
        int total = 0;
        try {
            while ((read = ais.read(buf, total, buf.length - total)) != -1 && total < buf.length) {
                total += read;
            }
        }
        catch (IOException ioe) {
            return null;
        }
        ByteBuffer buffer = WaveData.convertAudioBytes(buf, audioformat.getSampleSizeInBits() == 16);
        WaveData wavedata = new WaveData(buffer, channels, (int)audioformat.getSampleRate());
        try {
            ais.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return wavedata;
    }

    /*
     * Unable to fully structure code
     */
    private static ByteBuffer convertAudioBytes(byte[] audio_bytes, boolean two_bytes_data) {
        block2: {
            dest = ByteBuffer.allocateDirect(audio_bytes.length);
            dest.order(ByteOrder.nativeOrder());
            src = ByteBuffer.wrap(audio_bytes);
            src.order(ByteOrder.LITTLE_ENDIAN);
            if (!two_bytes_data) ** GOTO lbl17
            dest_short = dest.asShortBuffer();
            src_short = src.asShortBuffer();
            while (src_short.hasRemaining()) {
                dest_short.put(src_short.get());
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                dest.put(src.get());
lbl17:
                // 2 sources

                ** while (src.hasRemaining())
            }
        }
        dest.rewind();
        return dest;
    }
}

