/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.util.Display;

public final class Display {
    private static final boolean DEBUG = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lwjgl.util.Display");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static DisplayMode[] getAvailableDisplayModes(int minWidth, int minHeight, int maxWidth, int maxHeight, int minBPP, int maxBPP, int minFreq, int maxFreq) throws LWJGLException {
        DisplayMode[] modes = org.lwjgl.opengl.Display.getAvailableDisplayModes();
        if (LWJGLUtil.DEBUG) {
            System.out.println("Available screen modes:");
            int i = 0;
            while (i < modes.length) {
                System.out.println(modes[i]);
                ++i;
            }
        }
        ArrayList<DisplayMode> matches = new ArrayList<DisplayMode>(modes.length);
        int i = 0;
        while (i < modes.length) {
            if (!$assertionsDisabled && modes[i] == null) {
                throw new AssertionError((Object)(i + " " + modes.length));
            }
            if (!(minWidth != -1 && modes[i].getWidth() < minWidth || maxWidth != -1 && modes[i].getWidth() > maxWidth || minHeight != -1 && modes[i].getHeight() < minHeight || maxHeight != -1 && modes[i].getHeight() > maxHeight || minBPP != -1 && modes[i].getBitsPerPixel() < minBPP || maxBPP != -1 && modes[i].getBitsPerPixel() > maxBPP || modes[i].getFrequency() != 0 && (minFreq != -1 && modes[i].getFrequency() < minFreq || maxFreq != -1 && modes[i].getFrequency() > maxFreq))) {
                matches.add(modes[i]);
            }
            ++i;
        }
        DisplayMode[] ret = new DisplayMode[matches.size()];
        matches.toArray(ret);
        return ret;
    }

    public static DisplayMode setDisplayMode(DisplayMode[] dm, String[] param) throws Exception {
        int i;
        class Sorter
        implements Comparator {
            final 1.FieldAccessor[] field;

            Sorter(String[] stringArray) throws NoSuchFieldException {
                class FieldAccessor {
                    final String fieldName;
                    final int order;
                    final int preferred;
                    final boolean usePreferred;

                    FieldAccessor(String fieldName, int order, int preferred, boolean usePreferred) {
                        this.fieldName = fieldName;
                        this.order = order;
                        this.preferred = preferred;
                        this.usePreferred = usePreferred;
                    }

                    int getInt(DisplayMode mode) {
                        if ("width".equals(this.fieldName)) {
                            return mode.getWidth();
                        }
                        if ("height".equals(this.fieldName)) {
                            return mode.getHeight();
                        }
                        if ("freq".equals(this.fieldName)) {
                            return mode.getFrequency();
                        }
                        if ("bpp".equals(this.fieldName)) {
                            return mode.getBitsPerPixel();
                        }
                        throw new IllegalArgumentException("Unknown field " + this.fieldName);
                    }
                }
                this.field = new FieldAccessor[stringArray.length];
                int i = 0;
                while (i < this.field.length) {
                    int idx = stringArray[i].indexOf(61);
                    this.field[i] = idx > 0 ? new FieldAccessor(stringArray[i].substring(0, idx), 0, Integer.parseInt(stringArray[i].substring(idx + 1, stringArray[i].length())), true) : (stringArray[i].charAt(0) == '-' ? new FieldAccessor(stringArray[i].substring(1), -1, 0, false) : new FieldAccessor(stringArray[i], 1, 0, false));
                    ++i;
                }
            }

            public int compare(Object o1, Object o2) {
                DisplayMode dm1 = (DisplayMode)o1;
                DisplayMode dm2 = (DisplayMode)o2;
                int i = 0;
                while (i < this.field.length) {
                    int f1 = this.field[i].getInt(dm1);
                    int f2 = this.field[i].getInt(dm2);
                    if (this.field[i].usePreferred && f1 != f2) {
                        int absf2;
                        if (f1 == this.field[i].preferred) {
                            return -1;
                        }
                        if (f2 == this.field[i].preferred) {
                            return 1;
                        }
                        int absf1 = Math.abs(f1 - this.field[i].preferred);
                        if (absf1 < (absf2 = Math.abs(f2 - this.field[i].preferred))) {
                            return -1;
                        }
                        if (absf1 > absf2) {
                            return 1;
                        }
                    } else {
                        if (f1 < f2) {
                            return this.field[i].order;
                        }
                        if (f1 != f2) {
                            return -this.field[i].order;
                        }
                    }
                    ++i;
                }
                return 0;
            }
        }
        Arrays.sort(dm, new Sorter(param));
        if (LWJGLUtil.DEBUG) {
            System.out.println("Sorted display modes:");
            i = 0;
            while (i < dm.length) {
                System.out.println(dm[i]);
                ++i;
            }
        }
        i = 0;
        while (i < dm.length) {
            try {
                if (LWJGLUtil.DEBUG) {
                    System.out.println("Attempting to set displaymode: " + dm[i]);
                }
                org.lwjgl.opengl.Display.setDisplayMode((DisplayMode)dm[i]);
                return dm[i];
            }
            catch (Exception e) {
                if (LWJGLUtil.DEBUG) {
                    System.out.println("Failed to set display mode to " + dm[i]);
                    e.printStackTrace();
                }
                ++i;
            }
        }
        throw new Exception("Failed to set display mode.");
    }
}

