/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.screens;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.ImageBank;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.puppygames.applet.Binding;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.SFX;
import net.puppygames.applet.screens.GenericButtonHandler;
import net.puppygames.applet.screens.TitleScreen;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.Point;
import org.w3c.dom.Element;

public class BindingsScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    private static BindingsScreen instance;
    private static final int PHASE_NORMAL = 0;
    private static final int PHASE_WAIT = 1;
    private static final String OK = "ok";
    private static final String CANCEL = "cancel";
    private static final String INSTRUCTIONS = "instructions";
    private static final String KEY_PREFIX = "bindingarea.";
    private static final String BINDINGS_GROUP = "bindingarea";
    private static final String RESET = "reset";
    private String keys;
    private String mouse;
    private String controller;
    private String dpad;
    private Point offset = new Point(0, 0);
    private List keyAreas;
    private boolean allowMouse = true;
    private boolean allowKeyboard = true;
    private boolean allowController = true;
    private transient ImageBank keysImageBank;
    private transient ImageBank mouseImageBank;
    private transient ImageBank controllerImageBank;
    private transient ImageBank dpadImageBank;
    private transient int phase;
    private transient String binding;

    public BindingsScreen(String name) {
        super(name);
    }

    protected void doRegister() {
        instance = this;
    }

    protected void doDeregister() {
        instance = null;
    }

    public static void show() {
        if (instance != null) {
            if (!instance.isCreated()) {
                try {
                    instance.create();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    instance = null;
                    return;
                }
            }
            instance.open();
        }
    }

    protected void onClicked(String id) {
        GenericButtonHandler.onClicked(id);
        if (OK.equals(id)) {
            Game.saveBindings();
            TitleScreen.show();
        } else if (CANCEL.equals(id)) {
            if (this.phase == 0) {
                Game.loadBindings();
                TitleScreen.show();
            } else {
                this.doneBinding();
            }
        } else if (RESET.equals(id)) {
            Binding.resetToDefaults();
            this.update();
        } else if (id.startsWith(KEY_PREFIX)) {
            this.waitForInput(id.substring(KEY_PREFIX.length()));
        }
    }

    public void waitForInput(String binding) {
        this.phase = 1;
        this.setEnabled(OK, false);
        this.setEnabled(RESET, false);
        this.setVisible(INSTRUCTIONS, true);
        this.binding = binding;
        this.setKeyboardNavigationEnabled(false);
        this.setGroupEnabled(BINDINGS_GROUP, false);
        Game.setPauseEnabled(false);
        SFX.keyTyped();
    }

    protected void doTick() {
        int i;
        if (this.phase == 0) {
            return;
        }
        if (Game.wasKeyPressed(1)) {
            this.doneBinding();
            return;
        }
        if (this.allowKeyboard) {
            i = 0;
            while (i < 256) {
                if (Keyboard.isKeyDown((int)i) && i != 1 && i != 25) {
                    Binding.setBinding(this.binding, "keyboard", i);
                    this.doneBinding();
                }
                ++i;
            }
        }
        if (this.allowMouse) {
            i = 0;
            while (i < Mouse.getButtonCount()) {
                if (Mouse.isButtonDown((int)i)) {
                    Binding.setBinding(this.binding, "mouse", i);
                    this.doneBinding();
                }
                ++i;
            }
        }
        if (this.allowController && Controllers.getControllerCount() > 0) {
            Controller c = Controllers.getController((int)0);
            int i2 = 0;
            while (i2 < c.getButtonCount()) {
                if (c.isButtonPressed(i2)) {
                    Binding.setBinding(this.binding, "controller", i2);
                    this.doneBinding();
                }
                ++i2;
            }
            if (c.getPovX() < -0.5f) {
                Binding.setBinding(this.binding, "dpad", 2);
                this.doneBinding();
            }
            if (c.getPovX() > 0.5f) {
                Binding.setBinding(this.binding, "dpad", 0);
                this.doneBinding();
            }
            if (c.getPovY() < -0.5f) {
                Binding.setBinding(this.binding, "dpad", 1);
                this.doneBinding();
            }
            if (c.getPovY() > 0.5f) {
                Binding.setBinding(this.binding, "dpad", 3);
                this.doneBinding();
            }
        }
    }

    protected void doCleanup() {
        Iterator i = this.keyAreas.iterator();
        while (i.hasNext()) {
            ((KeyArea)((Object)i.next())).cleanup();
        }
    }

    protected void onOpen() {
        GenericButtonHandler.onOpen(this);
        Iterator i = this.keyAreas.iterator();
        while (i.hasNext()) {
            ((KeyArea)((Object)i.next())).init(this);
        }
    }

    public void doneBinding() {
        SFX.textEntered();
        this.phase = 0;
        this.setEnabled(OK, true);
        this.setEnabled(RESET, true);
        this.setVisible(INSTRUCTIONS, false);
        this.setKeyboardNavigationEnabled(true);
        this.setGroupEnabled(BINDINGS_GROUP, true);
        Game.setPauseEnabled(true);
        this.update();
    }

    private void update() {
        Iterator i = this.keyAreas.iterator();
        while (i.hasNext()) {
            ((KeyArea)((Object)i.next())).update();
        }
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        List children = XMLUtil.getChildren((Element)element, (String)"key");
        this.keyAreas = new LinkedList();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Element child = (Element)i.next();
            KeyArea section = new KeyArea();
            section.load(child, loader);
            this.keyAreas.add(section);
        }
    }

    protected void doCreateScreen() throws Exception {
        Iterator i = this.keyAreas.iterator();
        while (i.hasNext()) {
            KeyArea section = (KeyArea)((Object)i.next());
            section.create();
        }
    }

    protected void doDestroyScreen() {
        Iterator i = this.keyAreas.iterator();
        while (i.hasNext()) {
            KeyArea section = (KeyArea)((Object)i.next());
            section.destroy();
        }
    }

    private static class KeyArea
    extends Feature {
        private String binding;
        private Point location;
        private Point textLocation;
        private transient Sprite glyphSprite;
        private transient BindingsScreen screen;

        public KeyArea() {
            this.setAutoCreated();
            this.setSubResource(true);
        }

        void init(BindingsScreen screen) {
            this.screen = screen;
            this.glyphSprite = screen.allocateSprite((Object)this);
            this.glyphSprite.setLocation(this.location.getX(), this.location.getY(), 0);
            this.glyphSprite.setOffset(screen.offset.getX(), screen.offset.getY(), 0);
            this.glyphSprite.setLayer(1);
            this.update();
        }

        void cleanup() {
            if (this.glyphSprite != null) {
                this.glyphSprite.deallocate();
                this.glyphSprite = null;
            }
        }

        void update() {
            try {
                Binding b = (Binding)Resources.get((String)this.binding);
                if (b.getType() == null) {
                    System.out.println("No binding for " + this.binding);
                    this.glyphSprite.setVisible(false);
                } else {
                    this.glyphSprite.setVisible(true);
                    if (b.getType().equals("keyboard")) {
                        this.glyphSprite.setAppearance((AnimatedAppearance)this.screen.keysImageBank.getImage(b.getIndex()));
                    } else if (b.getType().equals("keyboard")) {
                        this.glyphSprite.setAppearance((AnimatedAppearance)this.screen.mouseImageBank.getImage(b.getIndex()));
                    } else if (b.getType().equals("controller")) {
                        this.glyphSprite.setAppearance((AnimatedAppearance)this.screen.controllerImageBank.getImage(b.getIndex()));
                    } else if (b.getType().equals("dpad")) {
                        this.glyphSprite.setAppearance((AnimatedAppearance)this.screen.dpadImageBank.getImage(b.getIndex()));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

