/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.References;
import org.lwjgl.opengl.StateTracker;

class GLChecks {
    private GLChecks() {
    }

    static References getReferences() {
        return StateTracker.getReferencesStack().getReferences();
    }

    private static boolean checkBufferObject(int buffer_enum, boolean state) {
        boolean is_enabled;
        IntBuffer scratch_buffer = GLContext.getCapabilities().scratch_int_buffer;
        GL11.glGetInteger(buffer_enum, scratch_buffer);
        boolean bl = is_enabled = scratch_buffer.get(0) != 0;
        return state == is_enabled;
    }

    static void ensureArrayVBOdisabled() {
        if (GLContext.getCapabilities().OpenGL15 && !GLChecks.checkBufferObject(34964, false) || GLContext.getCapabilities().GL_ARB_vertex_buffer_object && !GLChecks.checkBufferObject(34964, false)) {
            throw new OpenGLException("Cannot use Buffers when Array Buffer Object is enabled");
        }
    }

    static void ensureArrayVBOenabled() {
        if (GLContext.getCapabilities().OpenGL15 && !GLChecks.checkBufferObject(34964, true) || GLContext.getCapabilities().GL_ARB_vertex_buffer_object && !GLChecks.checkBufferObject(34964, true)) {
            throw new OpenGLException("Cannot use offsets when Array Buffer Object is disabled");
        }
    }

    static void ensureElementVBOdisabled() {
        if (GLContext.getCapabilities().OpenGL15 && !GLChecks.checkBufferObject(34965, false) || GLContext.getCapabilities().GL_ARB_vertex_buffer_object && !GLChecks.checkBufferObject(34965, false)) {
            throw new OpenGLException("Cannot use Buffers when Element Array Buffer Object is enabled");
        }
    }

    static void ensureElementVBOenabled() {
        if (GLContext.getCapabilities().OpenGL15 && !GLChecks.checkBufferObject(34965, true) || GLContext.getCapabilities().GL_ARB_vertex_buffer_object && !GLChecks.checkBufferObject(34965, true)) {
            throw new OpenGLException("Cannot use offsets when Element Array Buffer Object is disabled");
        }
    }

    static void ensurePackPBOdisabled() {
        if (GLContext.getCapabilities().GL_ARB_pixel_buffer_object && !GLChecks.checkBufferObject(35053, false) || GLContext.getCapabilities().GL_EXT_pixel_buffer_object && !GLChecks.checkBufferObject(35053, false)) {
            throw new OpenGLException("Cannot use Buffers when Pixel Pack Buffer Object is enabled");
        }
    }

    static void ensurePackPBOenabled() {
        if (GLContext.getCapabilities().GL_ARB_pixel_buffer_object && !GLChecks.checkBufferObject(35053, true) || GLContext.getCapabilities().GL_EXT_pixel_buffer_object && !GLChecks.checkBufferObject(35053, true)) {
            throw new OpenGLException("Cannot use offsets when Pixel Pack Buffer Object is disabled");
        }
    }

    static void ensureUnpackPBOdisabled() {
        if (GLContext.getCapabilities().GL_ARB_pixel_buffer_object && !GLChecks.checkBufferObject(35055, false) || GLContext.getCapabilities().GL_EXT_pixel_buffer_object && !GLChecks.checkBufferObject(35055, false)) {
            throw new OpenGLException("Cannot use Buffers when Pixel Unpack Buffer Object is enabled");
        }
    }

    static void ensureUnpackPBOenabled() {
        if (GLContext.getCapabilities().GL_ARB_pixel_buffer_object && !GLChecks.checkBufferObject(35055, true) || GLContext.getCapabilities().GL_EXT_pixel_buffer_object && !GLChecks.checkBufferObject(35055, true)) {
            throw new OpenGLException("Cannot use offsets when Pixel Unpack Buffer Object is disabled");
        }
    }

    static int calculateImageStorage(Buffer buffer, int format, int type, int width, int height, int depth) {
        return GLChecks.calculateImageStorage(format, type, width, height, depth) >> BufferUtils.getElementSizeExponent(buffer);
    }

    static int calculateTexImage1DStorage(Buffer buffer, int format, int type, int width, int border) {
        return GLChecks.calculateTexImage1DStorage(format, type, width, border) >> BufferUtils.getElementSizeExponent(buffer);
    }

    static int calculateTexImage2DStorage(Buffer buffer, int format, int type, int width, int height, int border) {
        return GLChecks.calculateTexImage2DStorage(format, type, width, height, border) >> BufferUtils.getElementSizeExponent(buffer);
    }

    static int calculateTexImage3DStorage(Buffer buffer, int format, int type, int width, int height, int depth, int border) {
        return GLChecks.calculateTexImage3DStorage(format, type, width, height, depth, border) >> BufferUtils.getElementSizeExponent(buffer);
    }

    private static int calculateImageStorage(int format, int type, int width, int height, int depth) {
        return GLChecks.calculateBytesPerPixel(format, type) * width * height * depth;
    }

    private static int calculateTexImage1DStorage(int format, int type, int width, int border) {
        return GLChecks.calculateBytesPerPixel(format, type) * (width + (border << 1));
    }

    private static int calculateTexImage2DStorage(int format, int type, int width, int height, int border) {
        return GLChecks.calculateTexImage1DStorage(format, type, width, border) * (height + (border << 1));
    }

    private static int calculateTexImage3DStorage(int format, int type, int width, int height, int depth, int border) {
        return GLChecks.calculateTexImage2DStorage(format, type, width, height, border) * (depth + (border << 1));
    }

    private static int calculateBytesPerPixel(int format, int type) {
        int epp;
        int bpe;
        switch (type) {
            case 5120: 
            case 5121: {
                bpe = 1;
                break;
            }
            case 5122: 
            case 5123: {
                bpe = 2;
                break;
            }
            case 5124: 
            case 5125: 
            case 5126: {
                bpe = 4;
                break;
            }
            default: {
                return 0;
            }
        }
        switch (format) {
            case 6406: 
            case 6409: {
                epp = 1;
                break;
            }
            case 6410: {
                epp = 2;
                break;
            }
            case 6407: 
            case 32992: {
                epp = 3;
                break;
            }
            case 6408: 
            case 32768: 
            case 32993: {
                epp = 4;
                break;
            }
            default: {
                return 0;
            }
        }
        return bpe * epp;
    }
}

