/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import java.util.ArrayList;
import net.java.games.input.Component;
import org.lwjgl.input.Controller;
import org.lwjgl.input.ControllerEvent;
import org.lwjgl.input.Controllers;

class JInputController
implements Controller {
    private net.java.games.input.Controller target;
    private int index;
    private ArrayList buttons = new ArrayList();
    private ArrayList axes = new ArrayList();
    private ArrayList pov = new ArrayList();
    private boolean[] buttonState;
    private float[] povValues;
    private float[] axesValue;
    private float[] axesMax;
    private float[] deadZones;
    private int xaxis = -1;
    private int yaxis = -1;
    private int zaxis = -1;
    private int rxaxis = -1;
    private int ryaxis = -1;
    private int rzaxis = -1;

    public JInputController(int index, net.java.games.input.Controller target) {
        this.target = target;
        this.index = index;
        Component[] sourceAxes = target.getComponents();
        int i = 0;
        while (i < sourceAxes.length) {
            if (sourceAxes[i].getIdentifier() instanceof Component.Identifier.Button) {
                this.buttons.add(sourceAxes[i]);
            } else if (sourceAxes[i].getIdentifier().equals(Component.Identifier.Axis.POV)) {
                this.pov.add(sourceAxes[i]);
            } else {
                this.axes.add(sourceAxes[i]);
            }
            ++i;
        }
        this.buttonState = new boolean[this.buttons.size()];
        this.povValues = new float[this.pov.size()];
        this.axesValue = new float[this.axes.size()];
        int buttonsCount = 0;
        int axesCount = 0;
        int i2 = 0;
        while (i2 < sourceAxes.length) {
            if (sourceAxes[i2].getIdentifier() instanceof Component.Identifier.Button) {
                this.buttonState[buttonsCount] = sourceAxes[i2].getPollData() != 0.0f;
                ++buttonsCount;
            } else if (!sourceAxes[i2].getIdentifier().equals(Component.Identifier.Axis.POV)) {
                this.axesValue[axesCount] = sourceAxes[i2].getPollData();
                if (sourceAxes[i2].getIdentifier().equals(Component.Identifier.Axis.X)) {
                    this.xaxis = axesCount;
                }
                if (sourceAxes[i2].getIdentifier().equals(Component.Identifier.Axis.Y)) {
                    this.yaxis = axesCount;
                }
                if (sourceAxes[i2].getIdentifier().equals(Component.Identifier.Axis.Z)) {
                    this.zaxis = axesCount;
                }
                if (sourceAxes[i2].getIdentifier().equals(Component.Identifier.Axis.RX)) {
                    this.rxaxis = axesCount;
                }
                if (sourceAxes[i2].getIdentifier().equals(Component.Identifier.Axis.RY)) {
                    this.ryaxis = axesCount;
                }
                if (sourceAxes[i2].getIdentifier().equals(Component.Identifier.Axis.RZ)) {
                    this.rzaxis = axesCount;
                }
                ++axesCount;
            }
            ++i2;
        }
        this.axesMax = new float[this.axes.size()];
        this.deadZones = new float[this.axes.size()];
        i2 = 0;
        while (i2 < this.axesMax.length) {
            this.axesMax[i2] = 1.0f;
            this.deadZones[i2] = 0.05f;
            ++i2;
        }
    }

    public String getName() {
        String name = this.target.getName();
        return name.substring(0, name.length() / 2);
    }

    public int getIndex() {
        return this.index;
    }

    public int getButtonCount() {
        return this.buttons.size();
    }

    public String getButtonName(int index) {
        Component button = (Component)this.buttons.get(index);
        return button.getName();
    }

    public boolean isButtonPressed(int index) {
        return this.buttonState[index];
    }

    public void poll() {
        float data;
        this.target.poll();
        int i = 0;
        while (i < this.getButtonCount()) {
            Component button = (Component)this.buttons.get(i);
            data = button.getPollData();
            if (this.buttonState[i] != (data != 0.0f)) {
                Controllers.addEvent(new ControllerEvent(this, 1, i, false, false));
            }
            this.buttonState[i] = data != 0.0f;
            ++i;
        }
        i = 0;
        while (i < this.pov.size()) {
            Component p = (Component)this.pov.get(i);
            data = p.getPollData();
            if (this.povValues[i] != data) {
                float prevX = this.getPovX();
                float prevY = this.getPovY();
                this.povValues[i] = data;
                if (prevX != this.getPovX()) {
                    Controllers.addEvent(new ControllerEvent(this, 3, 0, false, false));
                }
                if (prevY != this.getPovY()) {
                    Controllers.addEvent(new ControllerEvent(this, 4, 0, false, false));
                }
            }
            this.povValues[i] = data;
            ++i;
        }
        i = 0;
        while (i < this.getAxisCount()) {
            Component axis = (Component)this.axes.get(i);
            float value = axis.getPollData();
            if (Math.abs(value) < this.deadZones[i]) {
                value = 0.0f;
            }
            if (Math.abs(value) < axis.getDeadZone()) {
                value = 0.0f;
            }
            if (Math.abs(value) > this.axesMax[i]) {
                this.axesMax[i] = Math.abs(value);
            }
            if (this.axesValue[i] != (value /= this.axesMax[i])) {
                Controllers.addEvent(new ControllerEvent(this, 2, i, i == this.xaxis, i == this.yaxis));
            }
            this.axesValue[i] = value;
            ++i;
        }
    }

    public int getAxisCount() {
        return this.axes.size();
    }

    public String getAxisName(int index) {
        Component axis = (Component)this.axes.get(index);
        return axis.getName();
    }

    public float getAxisValue(int index) {
        return this.axesValue[index];
    }

    public float getXAxisValue() {
        if (this.xaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.xaxis);
    }

    public float getYAxisValue() {
        if (this.yaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.yaxis);
    }

    public float getXAxisDeadZone() {
        if (this.xaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.xaxis);
    }

    public float getYAxisDeadZone() {
        if (this.yaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.yaxis);
    }

    public void setXAxisDeadZone(float zone) {
        this.setDeadZone(this.xaxis, zone);
    }

    public void setYAxisDeadZone(float zone) {
        this.setDeadZone(this.yaxis, zone);
    }

    public float getDeadZone(int index) {
        return this.deadZones[index];
    }

    public void setDeadZone(int index, float zone) {
        this.deadZones[index] = zone;
    }

    public float getZAxisValue() {
        if (this.zaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.zaxis);
    }

    public float getZAxisDeadZone() {
        if (this.zaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.zaxis);
    }

    public void setZAxisDeadZone(float zone) {
        this.setDeadZone(this.zaxis, zone);
    }

    public float getRXAxisValue() {
        if (this.rxaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.rxaxis);
    }

    public float getRXAxisDeadZone() {
        if (this.rxaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.rxaxis);
    }

    public void setRXAxisDeadZone(float zone) {
        this.setDeadZone(this.rxaxis, zone);
    }

    public float getRYAxisValue() {
        if (this.ryaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.ryaxis);
    }

    public float getRYAxisDeadZone() {
        if (this.ryaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.ryaxis);
    }

    public void setRYAxisDeadZone(float zone) {
        this.setDeadZone(this.ryaxis, zone);
    }

    public float getRZAxisValue() {
        if (this.rzaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.rzaxis);
    }

    public float getRZAxisDeadZone() {
        if (this.rzaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.rzaxis);
    }

    public void setRZAxisDeadZone(float zone) {
        this.setDeadZone(this.rzaxis, zone);
    }

    public float getPovX() {
        if (this.pov.size() == 0) {
            return 0.0f;
        }
        float value = this.povValues[0];
        if (value == 0.875f || value == 0.125f || value == 1.0f) {
            return -1.0f;
        }
        if (value == 0.625f || value == 0.375f || value == 0.5f) {
            return 1.0f;
        }
        return 0.0f;
    }

    public float getPovY() {
        if (this.pov.size() == 0) {
            return 0.0f;
        }
        float value = this.povValues[0];
        if (value == 0.875f || value == 0.625f || value == 0.75f) {
            return 1.0f;
        }
        if (value == 0.125f || value == 0.375f || value == 0.25f) {
            return -1.0f;
        }
        return 0.0f;
    }
}

