/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public class Cursor {
    public static final int CURSOR_ONE_BIT_TRANSPARENCY = 1;
    public static final int CURSOR_8_BIT_ALPHA = 2;
    public static final int CURSOR_ANIMATION = 4;
    private final CursorElement[] cursors;
    private int index = 0;
    private boolean destroyed;

    public Cursor(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) throws LWJGLException {
        if ((Cursor.getCapabilities() & 1) == 0) {
            throw new IllegalStateException("Native cursors not supported");
        }
        BufferChecks.checkBuffer(images, width * height * numImages);
        if (!Mouse.isCreated()) {
            throw new IllegalStateException("Mouse must be created before creating cursor objects");
        }
        if (width * height * numImages > images.remaining()) {
            throw new IllegalArgumentException("width*height*numImages > images.remaining()");
        }
        if (delays != null && numImages > delays.remaining()) {
            BufferChecks.checkBuffer(delays, numImages);
        }
        if (xHotspot >= width || xHotspot < 0) {
            throw new IllegalArgumentException("xHotspot > width || xHotspot < 0");
        }
        if (yHotspot >= height || yHotspot < 0) {
            throw new IllegalArgumentException("yHotspot > height || yHotspot < 0");
        }
        Sys.initialize();
        yHotspot = height - 1 - yHotspot;
        this.cursors = Cursor.createCursors(width, height, xHotspot, yHotspot, numImages, images, delays);
    }

    public static int getMinCursorSize() {
        return Display.getImplementation().getMinCursorSize();
    }

    public static int getMaxCursorSize() {
        return Display.getImplementation().getMaxCursorSize();
    }

    public static int getCapabilities() {
        return Display.getImplementation().getNativeCursorCapabilities();
    }

    private static CursorElement[] createCursors(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) throws LWJGLException {
        CursorElement[] cursors;
        IntBuffer images_copy = BufferUtils.createIntBuffer(images.remaining());
        Cursor.flipImages(width, height, numImages, images, images_copy);
        switch (LWJGLUtil.getPlatform()) {
            case 2: 
            case 3: {
                cursors = new CursorElement[numImages];
                int i = 0;
                while (i < numImages) {
                    Object handle = Display.getImplementation().createCursor(width, height, xHotspot, yHotspot, 1, images_copy, null);
                    long delay = delays != null ? delays.get(i) : 0;
                    long timeout = System.currentTimeMillis();
                    cursors[i] = new CursorElement(handle, delay, timeout);
                    images_copy.position(width * height * (i + 1));
                    ++i;
                }
                break;
            }
            case 1: {
                Object handle = Display.getImplementation().createCursor(width, height, xHotspot, yHotspot, numImages, images_copy, delays);
                CursorElement cursor_element = new CursorElement(handle, -1L, -1L);
                cursors = new CursorElement[]{cursor_element};
                break;
            }
            default: {
                throw new RuntimeException("Unknown OS");
            }
        }
        return cursors;
    }

    private static void flipImages(int width, int height, int numImages, IntBuffer images, IntBuffer images_copy) {
        int i = 0;
        while (i < numImages) {
            int start_index = i * width * height;
            Cursor.flipImage(width, height, start_index, images, images_copy);
            ++i;
        }
    }

    private static void flipImage(int width, int height, int start_index, IntBuffer images, IntBuffer images_copy) {
        int y = 0;
        while (y < height >> 1) {
            int index_y_1 = y * width + start_index;
            int index_y_2 = (height - y - 1) * width + start_index;
            int x = 0;
            while (x < width) {
                int index1 = index_y_1 + x;
                int index2 = index_y_2 + x;
                int temp_pixel = images.get(index1 + images.position());
                images_copy.put(index1, images.get(index2 + images.position()));
                images_copy.put(index2, temp_pixel);
                ++x;
            }
            ++y;
        }
    }

    Object getHandle() {
        this.checkValid();
        return this.cursors[this.index].cursorHandle;
    }

    private void checkValid() {
        if (this.destroyed) {
            throw new IllegalStateException("The cursor is destroyed");
        }
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        if (Mouse.getNativeCursor() == this) {
            try {
                Mouse.setNativeCursor(null);
            }
            catch (LWJGLException lWJGLException) {
                // empty catch block
            }
        }
        int i = 0;
        while (i < this.cursors.length) {
            Display.getImplementation().destroyCursor(this.cursors[i].cursorHandle);
            ++i;
        }
        this.destroyed = true;
    }

    protected void setTimeout() {
        this.checkValid();
        this.cursors[this.index].timeout = System.currentTimeMillis() + this.cursors[this.index].delay;
    }

    protected boolean hasTimedOut() {
        this.checkValid();
        return this.cursors.length > 1 && this.cursors[this.index].timeout < System.currentTimeMillis();
    }

    protected void nextCursor() {
        this.checkValid();
        ++this.index;
        this.index %= this.cursors.length;
    }

    private static class CursorElement {
        final Object cursorHandle;
        final long delay;
        long timeout;

        CursorElement(Object cursorHandle, long delay, long timeout) {
            this.cursorHandle = cursorHandle;
            this.delay = delay;
            this.timeout = timeout;
        }
    }
}

