/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sound.SoundPlayer;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import org.w3c.dom.Element;

public class SoundCommand
extends Command {
    public static final long serialVersionUID = 1L;
    private static SoundPlayer soundPlayer;
    private String sound;
    private transient ALBuffer soundResource;

    public static void setSoundPlayer(SoundPlayer soundPlayer) {
        SoundCommand.soundPlayer = soundPlayer;
    }

    public static SoundPlayer getSoundPlayer() {
        return soundPlayer;
    }

    public boolean execute(Animated target, int tickRate) {
        if (this.soundResource != null && soundPlayer != null) {
            SoundEffect fx = soundPlayer.allocate(this.soundResource, (Object)target);
            fx.play(target);
        }
        return true;
    }

    protected void doCreate() throws Exception {
        this.soundResource = (ALBuffer)Resources.get(this.sound);
    }

    protected void doDestroy() {
        this.soundResource = null;
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        writer.writeAttribute("sound", this.sound);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.sound = XMLUtil.getString(element, "sound");
    }
}

