/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteEngine;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.WritableColor;

public class SerializedSprite
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static SpriteEngine spriteEngine;
    private Animation animation;
    private SpriteImage image;
    private int tick;
    private int sequence;
    private int loop;
    private int layer;
    private Vector3i location = new Vector3i();
    private Vector3i offset = new Vector3i();
    private boolean flash;
    private final Color[] color = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(255, 255, 255, 255)};
    private int xscale;
    private int yscale;
    private int alpha;
    private int angle;
    private boolean visible;
    private boolean active;
    private int event;
    private boolean paused;
    private boolean mirrored;
    private boolean flipped;

    public void fromSprite(Sprite source) {
        this.animation = source.getAnimation();
        this.image = source.getImage();
        this.loop = source.getLoop();
        this.tick = source.getTick();
        this.sequence = source.getSequence();
        this.layer = source.getLayer();
        source.getLocation(this.location);
        source.getOffset(this.offset);
        this.flash = source.isFlashing();
        source.getColor(0, (WritableColor)this.color[0]);
        source.getColor(1, (WritableColor)this.color[1]);
        source.getColor(2, (WritableColor)this.color[2]);
        source.getColor(3, (WritableColor)this.color[3]);
        this.xscale = source.getXScale();
        this.yscale = source.getYScale();
        this.alpha = source.getAlpha();
        this.angle = source.getAngle();
        this.visible = source.isVisible();
        this.active = source.isActive();
        this.event = source.getEvent();
        this.paused = source.isPaused();
        this.mirrored = source.isMirrored();
        this.flipped = source.isFlipped();
    }

    public void toSprite(Sprite dest) throws Exception {
        if (!dest.isAllocated()) {
            throw new Exception("Sprite is not allocated!");
        }
        dest.setAnimation(this.animation);
        dest.setImage(this.image);
        dest.setLoop(this.loop);
        dest.setTick(this.tick);
        dest.setSequence(this.sequence);
        dest.setLayer(this.layer);
        dest.setLocation(this.location.getX(), this.location.getY(), this.location.getZ());
        dest.setOffset(this.offset);
        dest.setFlash(this.flash);
        dest.setColor(0, (ReadableColor)this.color[0]);
        dest.setColor(1, (ReadableColor)this.color[1]);
        dest.setColor(2, (ReadableColor)this.color[2]);
        dest.setColor(3, (ReadableColor)this.color[3]);
        dest.setScale(this.xscale, this.yscale);
        dest.setAlpha(this.alpha);
        dest.setAngle(this.angle);
        dest.setVisible(this.visible);
        dest.setActive(this.active);
        dest.setEvent(this.event);
        dest.setPaused(this.paused);
        dest.setMirrored(this.mirrored);
        dest.setFlipped(this.flipped);
    }

    public static void setSpriteEngine(SpriteEngine spriteEngine) {
        SerializedSprite.spriteEngine = spriteEngine;
    }

    public static SpriteEngine getSpriteEngine() {
        return spriteEngine;
    }

    private Object readResolve() throws ObjectStreamException {
        Sprite sprite = spriteEngine.allocate(this);
        try {
            this.toSprite(sprite);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new InvalidObjectException("Failed to deserialize sprite due to " + e);
        }
        return sprite;
    }
}

