/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.resources.ColorParser;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.Colored;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.w3c.dom.Element;

public class ColorCommand
extends Command {
    public static final long serialVersionUID = 1L;
    private Color color;
    private int duration;

    public boolean execute(Animated target, int tickRate) {
        int currentSequence = target.getSequence();
        int currentTick = target.getTick();
        if (currentTick == 0) {
            Colored sprite = (Colored)((Object)target);
            sprite.setColors((ReadableColor)this.color);
        }
        if (currentTick >= this.duration) {
            target.setSequence(++currentSequence);
            target.setTick(0);
            return true;
        }
        target.setTick(currentTick + tickRate);
        return false;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.color = ColorParser.parse(XMLUtil.getString(element, "c"));
        this.duration = XMLUtil.getInt(element, "d", 0);
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        writer.writeAttribute("c", this.color.toString());
        writer.writeAttribute("d", this.duration, true);
    }
}

