/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.openal.ALStream;
import com.shavenpuppy.jglib.opengl.GLString;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.SerializedSprite;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteEngine;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.sprites.StaticSpriteEngine;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.puppygames.applet.Area;
import net.puppygames.applet.Binding;
import net.puppygames.applet.Game;
import net.puppygames.applet.Res;
import net.puppygames.applet.Tickable;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.Rectangle;
import org.w3c.dom.Element;

public abstract class Screen
extends Feature {
    public static final long serialVersionUID = 1L;
    private static final List screens;
    private static final int FADE_TIME = 15;
    private static final float START_DEPTH = -200.0f;
    private static final float END_DEPTH = 400.0f;
    private static final int SLOW_TICK_SPEED = 4;
    private int maxSprites = 64;
    private List areas;
    private boolean mouseVisible;
    private boolean keyboardNavigation;
    private String music;
    private String stream;
    private List hotkeys;
    private boolean dialog;
    private int offsetX;
    private int offsetY;
    private transient StaticSpriteEngine spriteEngine;
    private transient List backgroundEffects;
    private transient List foregroundEffects;
    private transient int timer;
    private transient int phase;
    private transient float alpha;
    private transient int mouseX;
    private transient int mouseY;
    private transient int oldMouseX;
    private transient int oldMouseY;
    private transient Map nameToArea;
    private transient boolean enabled;
    private transient List tickables;
    private transient Area focus;
    private transient Area grabbed;
    private transient boolean inited;
    private transient ALBuffer musicResource;
    private transient ALStream streamResource;
    private transient boolean paused;
    private transient boolean monkeying;
    private transient Area dragging;
    private transient boolean mouseWasDown;
    private transient boolean wasMouseGrabbed;
    private transient int selectTick;
    private transient int dragX;
    private transient int dragY;
    private transient int slowTick;
    private transient boolean disableKeyboardNavigation;
    private static final int CLOSED = 0;
    private static final int OPENING = 1;
    private static final int OPEN = 2;
    private static final int CLOSING = 3;
    private static final int BLOCKED = 4;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.puppygames.applet.Screen");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        screens = new ArrayList(4);
    }

    public Screen(String name) {
        super(name);
    }

    public final void setDefaultScreen() {
        SerializedSprite.setSpriteEngine((SpriteEngine)this.spriteEngine);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        List children = XMLUtil.getChildren((Element)element, (String)"area");
        this.areas = new ArrayList(children.size());
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Element child = (Element)i.next();
            Area area = new Area();
            area.load(child, loader);
            this.areas.add(area);
        }
        List hotkeyElements = XMLUtil.getChildren((Element)element, (String)"hotkey");
        this.hotkeys = new ArrayList(hotkeyElements.size());
        Iterator i2 = hotkeyElements.iterator();
        while (i2.hasNext()) {
            Element hotkeyElement = (Element)i2.next();
            HotKey hk = new HotKey();
            hk.load(hotkeyElement, loader);
            this.hotkeys.add(hk);
        }
    }

    protected final void doCreate() throws Exception {
        super.doCreate();
        if (!this.inited) {
            this.backgroundEffects = new ArrayList(4);
            this.foregroundEffects = new ArrayList(8);
            this.tickables = new ArrayList(256);
            this.spriteEngine = new StaticSpriteEngine(true, this.maxSprites, 1);
            this.spriteEngine.setLocked(true);
            this.spriteEngine.create();
            this.addTickable(new Tickable(){

                public void tick() {
                    Screen.this.spriteEngine.tick();
                }

                public void remove() {
                }

                public boolean isActive() {
                    return true;
                }

                public void spawn(Screen screen) {
                }

                public void update() {
                }
            });
            this.inited = true;
        }
        this.nameToArea = new HashMap();
        Iterator i = this.areas.iterator();
        while (i.hasNext()) {
            Area area = (Area)i.next();
            area.create();
            area.spawn(this);
            this.nameToArea.put(area.getID(), area);
        }
        i = this.hotkeys.iterator();
        while (i.hasNext()) {
            HotKey hk = (HotKey)((Object)i.next());
            hk.create();
        }
        this.doCreateScreen();
    }

    protected final void doDestroy() {
        super.doDestroy();
        Iterator i = this.areas.iterator();
        while (i.hasNext()) {
            Area area = (Area)i.next();
            area.destroy();
        }
        i = this.hotkeys.iterator();
        while (i.hasNext()) {
            HotKey hk = (HotKey)((Object)i.next());
            hk.destroy();
        }
        this.doDestroyScreen();
    }

    protected void doCreateScreen() throws Exception {
    }

    protected void doDestroyScreen() {
    }

    public void requestFocus(Area area) {
        if (area == null) {
            this.setFocus(null);
        } else if (area.isFocusable()) {
            this.setFocus(area.getID());
        }
    }

    private void checkKeyboardNavigation() {
        String changeFocus = null;
        int count = 0;
        while (count < this.areas.size()) {
            if (Binding.isBindingDown("focus.left.binding") || Binding.isBindingDown("focus.left.binding.alt")) {
                if (this.focus == null) {
                    this.findFirstFocus();
                } else {
                    changeFocus = this.focus.getLeftFocus();
                }
            } else if (Binding.isBindingDown("focus.right.binding") || Binding.isBindingDown("focus.right.binding.alt")) {
                if (this.focus == null) {
                    this.findFirstFocus();
                } else {
                    changeFocus = this.focus.getRightFocus();
                }
            } else if (Binding.isBindingDown("focus.up.binding") || Binding.isBindingDown("focus.up.binding.alt")) {
                if (this.focus == null) {
                    this.findFirstFocus();
                } else {
                    changeFocus = this.focus.getUpFocus();
                }
            } else if (Binding.isBindingDown("focus.down.binding") || Binding.isBindingDown("focus.down.binding.alt")) {
                if (this.focus == null) {
                    this.findFirstFocus();
                } else {
                    changeFocus = this.focus.getDownFocus();
                }
            } else if (Game.wasKeyPressed(15)) {
                if (this.focus == null) {
                    this.findFirstFocus();
                } else {
                    changeFocus = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? this.focus.getPrevFocus() : this.focus.getNextFocus();
                }
            } else {
                return;
            }
            if (changeFocus == null) {
                return;
            }
            this.setFocus(changeFocus);
            if (this.focus == null || !this.focus.isFocused()) continue;
            return;
        }
    }

    private void findFirstFocus() {
        Area area;
        Iterator i = this.areas.iterator();
        while (i.hasNext()) {
            area = (Area)i.next();
            if (!area.isFocusable() || !area.isDefaultFocus()) continue;
            this.focus = area;
            return;
        }
        i = this.areas.iterator();
        while (i.hasNext()) {
            area = (Area)i.next();
            if (!area.isFocusable()) continue;
            this.focus = area;
            return;
        }
        this.focus = null;
    }

    private void setFocus(String areaName) {
        this.focus = areaName == null ? null : this.getArea(areaName);
    }

    public float logicalXtoPhysicalX(float logicalX) {
        return logicalX * (float)Game.getViewPort().getWidth() / (float)Game.getWidth() + (float)Game.getViewPort().getX();
    }

    public float logicalYtoPhysicalY(float logicalY) {
        return logicalY * (float)Game.getViewPort().getHeight() / (float)Game.getHeight() + (float)Game.getViewPort().getY();
    }

    public float physicalXtoLogicalX(float physicalX) {
        return (float)Game.getWidth() * (physicalX - (float)Game.getViewPort().getX()) / (float)Game.getViewPort().getWidth();
    }

    public float physicalYtoLogicalY(float physicalY) {
        return (float)Game.getHeight() * (physicalY - (float)Game.getViewPort().getY()) / (float)Game.getViewPort().getHeight();
    }

    public final void tick() {
        this.oldMouseX = this.mouseX;
        this.oldMouseY = this.mouseY;
        this.mouseX = (int)this.physicalXtoLogicalX(Mouse.getX());
        this.mouseY = (int)this.physicalYtoLogicalY(Mouse.getY());
        if (!Screen.isMouseVisible()) {
            boolean setMousePosition = false;
            if (this.mouseX < 0) {
                this.mouseX = 0;
                setMousePosition = true;
            } else if (this.mouseX >= Game.getWidth()) {
                this.mouseX = Game.getWidth() - 1;
                setMousePosition = true;
            }
            if (this.mouseY < 0) {
                this.mouseY = 0;
                setMousePosition = true;
            } else if (this.mouseY >= Game.getHeight()) {
                this.mouseY = Game.getHeight() - 1;
                setMousePosition = true;
            }
            if (setMousePosition) {
                Mouse.setCursorPosition((int)((int)this.logicalXtoPhysicalX(this.mouseX)), (int)((int)this.logicalYtoPhysicalY(this.mouseY)));
            }
        }
        switch (this.phase) {
            case 1: {
                if (++this.timer >= 15) {
                    this.phase = 2;
                    this.timer = 0;
                } else {
                    this.doTick();
                    this.tickEverything();
                    this.postTick();
                    break;
                }
            }
            case 2: {
                if (this.paused) break;
                if (this.enabled && !this.monkeying) {
                    if (this.keyboardNavigation) {
                        this.checkKeyboardNavigation();
                    }
                    int i = 0;
                    while (i < this.areas.size()) {
                        Area area = (Area)this.areas.get(i);
                        area.tick();
                        ++i;
                    }
                    if (this.hotkeys != null) {
                        int numKeys = this.hotkeys.size();
                        int i2 = 0;
                        while (i2 < numKeys) {
                            HotKey hotKey = (HotKey)((Object)this.hotkeys.get(i2));
                            hotKey.check();
                            ++i2;
                        }
                    }
                }
                Game.wasKeyPressed(87);
                if (this.monkeying) {
                    this.monkey();
                } else {
                    this.doTick();
                    this.tickEverything();
                    this.postTick();
                }
                while (Keyboard.next()) {
                }
                while (Mouse.next()) {
                }
                while (Controllers.next()) {
                }
                break;
            }
            case 3: {
                if (++this.timer < 15) break;
                this.phase = 0;
                this.removeAllTickables();
                this.doCleanup();
                break;
            }
            case 0: {
                break;
            }
            case 4: {
                if (this.paused) break;
                this.doTick();
                this.tickEverything();
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    private void tickEverything() {
        int i = 0;
        while (i < this.tickables.size()) {
            Tickable tickable = (Tickable)this.tickables.get(i);
            if (tickable.isActive()) {
                tickable.tick();
            }
            if (tickable.isActive()) {
                ++i;
                continue;
            }
            int n = this.tickables.size() - 1;
            this.tickables.set(i, this.tickables.get(n));
            this.tickables.remove(n);
            tickable.remove();
        }
        int n = this.tickables.size();
        int i2 = 0;
        while (i2 < n) {
            Tickable tickable = (Tickable)this.tickables.get(i2);
            tickable.update();
            ++i2;
        }
    }

    public boolean mouseMoved() {
        return this.mouseX != this.oldMouseX || this.mouseY != this.oldMouseY;
    }

    protected void doTick() {
    }

    protected void postTick() {
    }

    public final void addTickable(Tickable tickable) {
        if (!$assertionsDisabled && this.tickables.contains(tickable)) {
            throw new AssertionError((Object)("Tickable " + tickable + " already added to " + (Object)((Object)this)));
        }
        this.tickables.add(tickable);
    }

    public final void addBackgroundEffect(Effect effect) {
        this.backgroundEffects.add(effect);
        this.addTickable(effect);
    }

    public final void addForegroundEffect(Effect effect) {
        this.foregroundEffects.add(effect);
        this.addTickable(effect);
    }

    public final void removeBackgroundEffect(Effect effect) {
        this.backgroundEffects.remove(effect);
    }

    public final void removeForegroundEffect(Effect effect) {
        this.foregroundEffects.remove(effect);
    }

    public final void removeAllTickables() {
        int n = this.tickables.size();
        int i = 0;
        while (i < n) {
            Tickable tickable = (Tickable)this.tickables.get(i);
            tickable.remove();
            if (tickable.isActive()) {
                ++i;
                continue;
            }
            this.tickables.set(i, this.tickables.get(--n));
            this.tickables.remove(n);
        }
    }

    protected void onClicked(String id) {
    }

    protected void onHover(String id, boolean on) {
    }

    private boolean isActive() {
        return this.phase != 0;
    }

    public final void close(boolean instantly) {
        if (this.isClosing() || this.isClosed()) {
            return;
        }
        this.phase = 3;
        this.timer = 0;
        this.focus = null;
        this.onClose();
        if (instantly) {
            this.removeAllTickables();
            this.doCleanup();
            this.phase = 0;
        } else {
            this.phase = 3;
        }
    }

    public final void close() {
        this.close(false);
    }

    protected void onClose() {
    }

    public final void open() {
        if (this.isOpen() || this.isOpening()) {
            return;
        }
        int i = 0;
        while (i < screens.size()) {
            Screen screen = (Screen)((Object)screens.get(i));
            if (screen == this) {
                screen.removeAllTickables();
                screen.doCleanup();
            } else if (this.dialog && screen.phase != 0 && screen.phase != 3) {
                screen.phase = 4;
            } else {
                screen.close();
            }
            ++i;
        }
        if (screens.contains((Object)this)) {
            screens.remove((Object)this);
        }
        screens.add(this);
        this.phase = 1;
        this.enabled = true;
        this.timer = 0;
        this.focus = null;
        if (this.musicResource != null) {
            Game.playMusic(this.musicResource, 60);
        }
        if (this.streamResource != null) {
            Game.playMusic(this.streamResource, 60);
        }
        Iterator i2 = this.areas.iterator();
        while (i2.hasNext()) {
            Area area = (Area)i2.next();
            area.init();
        }
        this.onOpen();
    }

    protected void onOpen() {
    }

    protected void onReopen() {
    }

    protected void doCleanup() {
    }

    public final void render() {
        float depth;
        float alpha;
        switch (this.phase) {
            case 3: {
                alpha = LinearInterpolator.instance.interpolate(1.0f, 0.0f, (float)this.timer / 15.0f);
                depth = LinearInterpolator.instance.interpolate(0.0f, 400.0f, (float)this.timer / 15.0f);
                break;
            }
            case 1: {
                alpha = LinearInterpolator.instance.interpolate(0.0f, 1.0f, (float)this.timer / 15.0f);
                depth = LinearInterpolator.instance.interpolate(-200.0f, 0.0f, (float)this.timer / 15.0f);
                break;
            }
            case 2: 
            case 4: {
                alpha = 1.0f;
                depth = 0.0f;
                break;
            }
            default: {
                float alpha2 = 0.0f;
                float depth2 = 0.0f;
                return;
            }
        }
        this.preRender();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.offsetX, (float)this.offsetY, (float)depth);
        this.renderBackground();
        this.renderEffects(this.backgroundEffects);
        this.spriteEngine.setAlpha(alpha);
        this.spriteEngine.render();
        Iterator i = this.areas.iterator();
        while (i.hasNext()) {
            Area area = (Area)i.next();
            area.render();
        }
        this.renderForeground();
        this.renderEffects(this.foregroundEffects);
        this.postRender();
        if (this.monkeying) {
            this.renderMonkeying();
        }
        GL11.glPopMatrix();
    }

    private void renderEffects(List effects) {
        int n = effects.size();
        int i = 0;
        while (i < n) {
            Effect effect = (Effect)effects.get(i);
            effect.render();
            ++i;
        }
    }

    protected void renderBackground() {
    }

    protected void renderForeground() {
    }

    protected void preRender() {
    }

    protected void postRender() {
    }

    public final Sprite allocateSprite(Object owner) {
        return this.spriteEngine.allocate(owner);
    }

    public static void tickAllScreens() {
        Screen top = Screen.getTopScreen();
        if (top != null && top.isBlocked()) {
            top.phase = 2;
            top.onReopen();
        }
        int i = 0;
        while (i < screens.size()) {
            Screen screen = (Screen)((Object)screens.get(i));
            screen.tick();
            if (screen.isActive()) {
                ++i;
                continue;
            }
            screens.remove(i);
        }
        boolean grabbed = Mouse.isGrabbed();
        if (grabbed == Screen.isMouseVisible() && top != null && !top.monkeying) {
            Mouse.setGrabbed((!Screen.isMouseVisible() ? 1 : 0) != 0);
        }
    }

    public static void renderAllScreens() {
        int i = 0;
        while (i < screens.size()) {
            Screen screen = (Screen)((Object)screens.get(i));
            screen.render();
            ++i;
        }
    }

    public static final boolean isMouseVisible() {
        if (screens.size() > 0) {
            Screen topmost = (Screen)((Object)screens.get(screens.size() - 1));
            return topmost.mouseVisible;
        }
        return true;
    }

    protected final float getAlpha() {
        return this.alpha;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public Area getArea(String name) {
        Area ret = (Area)this.nameToArea.get(name.toLowerCase());
        return ret;
    }

    public final boolean isOpening() {
        return this.phase == 1;
    }

    public final boolean isClosing() {
        return this.phase == 3;
    }

    public final boolean isClosed() {
        return this.phase == 0;
    }

    public final boolean isOpen() {
        return this.phase == 2;
    }

    public final boolean isBlocked() {
        return this.phase == 4;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
        Iterator i = this.areas.iterator();
        while (i.hasNext()) {
            Area area = (Area)i.next();
            area.setEnabled(enabled);
        }
    }

    public final void setKeyboardNavigationEnabled(boolean keyboardNavigation) {
        this.disableKeyboardNavigation = !keyboardNavigation;
    }

    public final boolean isKeyboardNavigationEnabled() {
        return this.keyboardNavigation && !this.disableKeyboardNavigation;
    }

    public final void nextFocus() {
    }

    public final void prevFocus() {
    }

    public Area getFocus() {
        return this.focus;
    }

    public void setEnabled(String area, boolean enabled) {
        Area a = this.getArea(area);
        if (a == null) {
            return;
        }
        a.setEnabled(enabled);
    }

    public void setVisible(String area, boolean visible) {
        Area a = this.getArea(area);
        if (a == null) {
            return;
        }
        a.setVisible(visible);
    }

    public void setGroupEnabled(String group, boolean enabled) {
        int n = this.areas.size();
        int i = 0;
        while (i < n) {
            Area area = (Area)this.areas.get(i);
            if (area.isInGroup(group)) {
                area.setEnabled(enabled);
            }
            ++i;
        }
    }

    public void setGroupVisible(String group, boolean visible) {
        int n = this.areas.size();
        int i = 0;
        while (i < n) {
            Area area = (Area)this.areas.get(i);
            if (area.isInGroup(group)) {
                area.setVisible(visible);
            }
            ++i;
        }
    }

    public void setGroupAlpha(String group, int alpha) {
        int n = this.areas.size();
        int i = 0;
        while (i < n) {
            Area area = (Area)this.areas.get(i);
            if (area.isInGroup(group)) {
                area.setAlpha(alpha);
            }
            ++i;
        }
    }

    public static Screen getTopScreen() {
        if (screens.size() == 0) {
            return null;
        }
        return (Screen)((Object)screens.get(screens.size() - 1));
    }

    public List getAreasUnder(int x, int y) {
        LinkedList<Area> ret = new LinkedList<Area>();
        int n = this.areas.size();
        int i = 0;
        while (i < n) {
            Area area = (Area)this.areas.get(i);
            if (area.isVisible() && area.getBounds().contains(x, y)) {
                ret.add(area);
            }
            ++i;
        }
        return ret;
    }

    public List getAreas() {
        return Collections.unmodifiableList(this.areas);
    }

    public void setGrabbed(Area grabbed) {
        this.grabbed = grabbed;
    }

    public Area getGrabbed() {
        return this.grabbed;
    }

    public void setOffset(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    private void monkey() {
        Rectangle r;
        if (Mouse.isButtonDown((int)0)) {
            if (this.mouseWasDown && this.dragging != null) {
                r = this.dragging.getBounds();
                this.dragging.setBounds(this.mouseX - this.dragX, this.mouseY - this.dragY, r.getWidth(), r.getHeight());
            } else {
                int n = this.areas.size();
                this.dragging = null;
                int i = n;
                while (--i >= 0) {
                    Area area = (Area)this.areas.get(i);
                    Rectangle r2 = area.getBounds();
                    if (!r2.contains(this.mouseX, this.mouseY)) continue;
                    this.dragging = area;
                    this.dragX = this.mouseX - r2.getX();
                    this.dragY = this.mouseY - r2.getY();
                    break;
                }
            }
            this.mouseWasDown = true;
        } else {
            this.mouseWasDown = false;
        }
        if (this.dragging != null) {
            if (this.slowTick > 0) {
                --this.slowTick;
            } else {
                r = this.dragging.getBounds();
                ReadablePoint of = this.dragging.getOffset();
                SpriteImage si = this.dragging.getCurrentImage();
                ReadablePoint to = this.dragging.getTextOffset();
                int tx = to.getX();
                int ty = to.getY();
                if (Keyboard.isKeyDown((int)19) && si != null) {
                    r.setSize(si.getWidth(), si.getHeight());
                }
                boolean ctrlDown = Keyboard.isKeyDown((int)29);
                if (Keyboard.isKeyDown((int)42) && Keyboard.isKeyDown((int)56)) {
                    int oy;
                    int ox;
                    if (of == null) {
                        ox = 0;
                        oy = 0;
                    } else {
                        ox = of.getX();
                        oy = of.getY();
                    }
                    if (Keyboard.isKeyDown((int)200)) {
                        ++oy;
                        int n = this.slowTick = ctrlDown ? 4 : 0;
                    }
                    if (Keyboard.isKeyDown((int)208)) {
                        --oy;
                        int n = this.slowTick = ctrlDown ? 4 : 0;
                    }
                    if (Keyboard.isKeyDown((int)203)) {
                        --ox;
                        int n = this.slowTick = ctrlDown ? 4 : 0;
                    }
                    if (Keyboard.isKeyDown((int)205)) {
                        ++ox;
                        this.slowTick = ctrlDown ? 4 : 0;
                    }
                    this.dragging.setOffset(ox, oy);
                } else if (Keyboard.isKeyDown((int)42)) {
                    if (Keyboard.isKeyDown((int)200)) {
                        r.setSize(r.getWidth(), r.getHeight() + 1);
                        int n = this.slowTick = ctrlDown ? 4 : 0;
                    }
                    if (Keyboard.isKeyDown((int)208)) {
                        r.setSize(r.getWidth(), r.getHeight() - 1);
                        int n = this.slowTick = ctrlDown ? 4 : 0;
                    }
                    if (Keyboard.isKeyDown((int)203)) {
                        r.setSize(r.getWidth() - 1, r.getHeight());
                        int n = this.slowTick = ctrlDown ? 4 : 0;
                    }
                    if (Keyboard.isKeyDown((int)205)) {
                        r.setSize(r.getWidth() + 1, r.getHeight());
                        this.slowTick = ctrlDown ? 4 : 0;
                    }
                } else if (Keyboard.isKeyDown((int)56)) {
                    if (Keyboard.isKeyDown((int)200)) {
                        ++ty;
                        int n = this.slowTick = ctrlDown ? 4 : 0;
                    }
                    if (Keyboard.isKeyDown((int)208)) {
                        --ty;
                        int n = this.slowTick = ctrlDown ? 4 : 0;
                    }
                    if (Keyboard.isKeyDown((int)203)) {
                        --tx;
                        int n = this.slowTick = ctrlDown ? 4 : 0;
                    }
                    if (Keyboard.isKeyDown((int)205)) {
                        ++tx;
                        this.slowTick = ctrlDown ? 4 : 0;
                    }
                } else {
                    if (Keyboard.isKeyDown((int)200)) {
                        r.setLocation(r.getX(), r.getY() + 1);
                        int n = this.slowTick = ctrlDown ? 4 : 0;
                    }
                    if (Keyboard.isKeyDown((int)208)) {
                        r.setLocation(r.getX(), r.getY() - 1);
                        int n = this.slowTick = ctrlDown ? 4 : 0;
                    }
                    if (Keyboard.isKeyDown((int)203)) {
                        r.setLocation(r.getX() - 1, r.getY());
                        int n = this.slowTick = ctrlDown ? 4 : 0;
                    }
                    if (Keyboard.isKeyDown((int)205)) {
                        r.setLocation(r.getX() + 1, r.getY());
                        this.slowTick = ctrlDown ? 4 : 0;
                    }
                }
                this.dragging.setBounds(r.getX(), r.getY(), r.getWidth(), r.getHeight());
                this.dragging.setTextOffset(tx, ty);
            }
        }
        if (Game.wasKeyPressed(45)) {
            try {
                PrintWriter pw = new PrintWriter(System.out);
                XMLResourceWriter writer = new XMLResourceWriter((Writer)pw);
                Iterator i = this.areas.iterator();
                while (i.hasNext()) {
                    Area a = (Area)i.next();
                    a.toXML(writer);
                }
                pw.flush();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private void renderMonkeying() {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        int n = this.areas.size();
        boolean foundHover = false;
        int i = n;
        while (--i >= 0) {
            Area area = (Area)this.areas.get(i);
            boolean hover = false;
            Rectangle r = area.getBounds();
            if (r == null) {
                ReadablePoint p = area.getPosition();
                SpriteImage si = area.getCurrentImage();
                if (si != null && p != null) {
                    r = new Rectangle(p.getX(), p.getY(), si.getWidth(), si.getHeight());
                }
            }
            if (!foundHover && r != null && r.contains(this.mouseX, this.mouseY)) {
                foundHover = true;
                hover = true;
            }
            if (r == null) continue;
            this.renderMonkeyedArea(area.getID(), r, hover);
        }
    }

    private void renderMonkeyedArea(String id, Rectangle r, boolean hover) {
        boolean stippled;
        if (hover) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        }
        boolean bl = stippled = this.dragging != null && this.dragging.getID().equals(id);
        if (stippled) {
            this.selectTick = (this.selectTick + 1) % 64;
            GL11.glLineStipple((int)1, (short)((short)(986895 >> (this.selectTick >> 3))));
            GL11.glEnable((int)2852);
        }
        GL11.glBegin((int)2);
        GL11.glVertex2i((int)r.getX(), (int)r.getY());
        GL11.glVertex2i((int)(r.getX() + r.getWidth()), (int)r.getY());
        GL11.glVertex2i((int)(r.getX() + r.getWidth()), (int)(r.getY() + r.getHeight()));
        GL11.glVertex2i((int)r.getX(), (int)(r.getY() + r.getHeight()));
        GL11.glEnd();
        if (stippled) {
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            GLString s = new GLString(id, Res.getTinyFont());
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            s.setLocation(r.getX() + 1, r.getY() + r.getHeight() - 1);
            s.render();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            s.setLocation(r.getX(), r.getY() + r.getHeight());
            s.render();
            GLString s2 = new GLString(String.valueOf(r.getX()) + ", " + r.getY(), Res.getTinyFont());
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            s2.setLocation(r.getX() + 1, r.getY() - 1);
            s2.render();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            s2.setLocation(r.getX(), r.getY());
            s2.render();
            GLString s3 = new GLString(String.valueOf(r.getWidth()) + "x" + r.getHeight(), Res.getTinyFont());
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            s3.setLocation(r.getX() + r.getWidth() - s3.getBounds(null).getWidth() + 1, r.getY() + r.getHeight() - s3.getBounds(null).getHeight() - 1);
            s3.render();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            s3.setLocation(r.getX() + r.getWidth() - s3.getBounds(null).getWidth(), r.getY() + r.getHeight() - s3.getBounds(null).getHeight());
            s3.render();
            GL11.glDisable((int)3553);
        }
        if (!stippled) {
            GL11.glLineStipple((int)1, (short)-1);
            GL11.glDisable((int)2852);
        }
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isPaused() {
        return this.paused;
    }

    private class HotKey
    extends Feature {
        private String modifier;
        private String key;
        private String area;
        private String command;
        private transient boolean wasDown;

        public HotKey() {
            this.setAutoCreated();
            this.setSubResource(true);
        }

        void check() {
            int k = Keyboard.getKeyIndex((String)this.key);
            if (k != 0) {
                if (Keyboard.isKeyDown((int)k)) {
                    int k2 = Keyboard.getKeyIndex((String)this.modifier);
                    if (k2 != 0 && !Keyboard.isKeyDown((int)k2)) {
                        this.wasDown = false;
                        return;
                    }
                    if (this.command != null) {
                        if (this.wasDown) {
                            return;
                        }
                        this.wasDown = true;
                        Screen.this.onClicked(this.command);
                    } else {
                        Area a = Screen.this.getArea(this.area);
                        if (a != null && a.isEnabled()) {
                            if (this.wasDown) {
                                return;
                            }
                            this.wasDown = true;
                            Screen.this.onClicked(this.area);
                        }
                    }
                } else {
                    this.wasDown = false;
                }
            }
        }
    }
}

