/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.util.FPMath;
import invaders.Bullet;
import invaders.EnemyBullet;
import invaders.Entity;
import invaders.GameScreen;
import invaders.Gidrah;
import invaders.Invaders;
import invaders.Laser;
import invaders.Res;
import invaders.TurretFeature;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;

public class Turret
extends Entity {
    private static final long serialVersionUID = 1L;
    private final Gidrah parent;
    private TurretFeature turretFeature;
    private int hitPoints;
    private transient Emitter smokeAndSparks;
    private int flashTick;
    private Bullet immune;

    public Turret(Gidrah parent, TurretFeature turretFeature) {
        this.parent = parent;
        this.turretFeature = turretFeature;
        this.hitPoints = turretFeature.getHitPoints() + Invaders.getGameState().getTotalMultiplier() / 3;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        try {
            this.turretFeature.create();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new IOException("Failed to load turret due to " + e);
        }
    }

    protected void doSpawn() {
        this.setAppearance((AnimatedAppearance)this.turretFeature.getAnimation());
    }

    protected void doRespawn() {
        this.setAppearance((AnimatedAppearance)this.turretFeature.getAnimation());
    }

    public boolean canCollide() {
        return this.parent.canCollide();
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithTurret(this);
    }

    public float getRadius() {
        return 12.0f;
    }

    public boolean canCollideWithLaser() {
        return this.canCollide();
    }

    public void onCollisionWithBullet(Bullet bullet) {
        if (this.immune == bullet) {
            return;
        }
        this.immune = bullet;
        this.damage(bullet.getDamage());
    }

    public void onCollisionWithLaser(Laser laser) {
        this.damage(1);
    }

    private void damage(int wounds) {
        this.hitPoints -= wounds;
        if (this.hitPoints <= 0) {
            this.kill();
        } else if (this.smokeAndSparks == null && this.hitPoints <= this.turretFeature.getHitPoints() / 3) {
            this.smokeAndSparks = Res.getTurretSmokeAndSparksEmitter().spawn((Screen)GameScreen.getInstance());
            this.smokeAndSparks.setLocation(this.getX(), this.getY());
            this.setFlash(true);
            this.flashTick = 2;
        } else {
            Emitter e = Res.getTurretRicochetEmitterFeature().spawn((Screen)GameScreen.getInstance());
            e.setLocation(this.getX(), this.getY());
            this.setFlash(true);
            this.flashTick = 2;
        }
    }

    public void kill() {
        if (!this.isActive()) {
            return;
        }
        Emitter e = Res.getTurretExplosionEmitterFeature().spawn((Screen)GameScreen.getInstance());
        e.setLocation(this.getX(), this.getY());
        this.remove();
    }

    protected void doRemove() {
        if (this.smokeAndSparks != null) {
            this.smokeAndSparks.remove();
            this.smokeAndSparks = null;
        }
    }

    protected void doTick() {
        this.setLocation(this.parent.getX() + (float)this.turretFeature.getX(), this.parent.getY() + (float)this.turretFeature.getY());
        if (this.smokeAndSparks != null) {
            this.smokeAndSparks.setLocation(this.getX(), this.getY());
        }
        if (this.flashTick > 0) {
            --this.flashTick;
            if (this.flashTick == 0) {
                this.setFlash(false);
            }
        }
        if (this.getEvent() == 1) {
            this.setEvent(0);
            if (!this.parent.canCollide()) {
                return;
            }
            EnemyBullet eb = this.turretFeature.getBullet().spawn(GameScreen.getInstance());
            eb.setLocation(this.getX(), this.getY());
            if (this.turretFeature.getBullet().isCurveBall()) {
                float vx = this.parent.getBehaviourInstance().getVX();
                int angle = this.getAngle();
                float avx = (float)Math.cos(FPMath.doubleValue((long)angle) * Math.PI * 2.0) * this.turretFeature.getBullet().getInitialVelocity();
                eb.setVX(avx + vx);
            }
        }
    }
}

