/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import invaders.AddonFeature;
import invaders.Bullet;
import invaders.BulletFeature;
import invaders.EnemyBullet;
import invaders.Entity;
import invaders.GameScreen;
import invaders.Gidrah;
import invaders.Invaders;
import invaders.Res;
import invaders.SFX;
import invaders.Smartbomb;
import invaders.behaviours.AlienLaserEffect;
import net.puppygames.applet.Binding;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.LabelEffect;
import net.puppygames.applet.effects.StrobeEffect;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.Color;

public class Player
extends Entity {
    private static final long serialVersionUID = 1L;
    public static final int BULLET_DELAY = 20;
    private static final float NORMAL_RADIUS = 12.0f;
    private static final float SHIELD_RADIUS = 30.0f;
    int phase;
    static final int PHASE_SPAWNING = 0;
    static final int PHASE_ALIVE = 1;
    static final int PHASE_DEAD = 2;
    int tick;
    int bulletTick = 0;
    boolean wasShooting;
    int smartTick = 0;
    static final int SMART_DELAY = 60;
    static final int SPAWN_DURATION = 60;
    static final int EXIT_DURATION = 120;
    static final int DEAD_DURATION = 500;
    private int immune;
    private static final int IMMUNE_TIME = 4;
    private boolean wasDamaged = false;
    private int superGunTick;
    private Sprite invulnerabilitySprite;
    private transient SoundEffect invulnerabilitySound;
    private int invulnTick;
    private Sprite[] addonSprite;
    private boolean ultraImmune;
    private transient AlienLaserEffect lastLaserEffect;
    static /* synthetic */ Class class$0;

    public void enableSuperGun(int duration) {
        this.superGunTick += duration;
    }

    public void enableInvulnerability(int duration) {
        this.invulnTick += duration;
        if (this.invulnerabilitySprite == null) {
            this.invulnerabilitySprite = GameScreen.getInstance().allocateSprite(this);
            if (this.invulnerabilitySprite == null) {
                return;
            }
            this.invulnerabilitySprite.setLayer(3);
            this.invulnerabilitySprite.setAppearance(Res.getInvulnerabilityAppearance());
        }
        if (this.invulnerabilitySound == null) {
            this.invulnerabilitySound = Invaders.allocateSound((ALBuffer)Res.getInvulnerabilitySound());
        }
    }

    protected void doSpawn() {
        this.immune = 120;
        this.setLocation(Invaders.getWidth() / 2, 19.0f);
        this.setVisible(true);
        this.phase = 0;
        this.tick = 0;
        this.setAppearance((AnimatedAppearance)Res.getPlayerIdleAnimation());
        this.smartTick = 30;
        this.addonSprite = new Sprite[4];
        int i = 0;
        while (i < Invaders.getGameState().getAddOn()) {
            this.addonSprite[i] = GameScreen.getInstance().allocateSprite(this);
            AddonFeature.getAddon(i).init(this.addonSprite[i]);
            ++i;
        }
    }

    protected void doRespawn() {
        this.immune = 30;
        if (this.isInvulnerable()) {
            this.invulnerabilitySound = Game.allocateSound((ALBuffer)Res.getInvulnerabilitySound());
        }
    }

    public boolean isAlive() {
        return this.phase != 2;
    }

    public boolean isInvulnerable() {
        return this.invulnTick > 0;
    }

    protected void doRemove() {
        if (this.invulnerabilitySprite != null) {
            this.invulnerabilitySprite.deallocate();
            this.invulnerabilitySprite = null;
        }
        if (this.invulnerabilitySound != null) {
            this.invulnerabilitySound.deactivate();
            this.invulnerabilitySound = null;
        }
        int i = 0;
        while (i < 4) {
            if (this.addonSprite[i] != null) {
                this.addonSprite[i].deallocate();
                this.addonSprite[i] = null;
            }
            ++i;
        }
    }

    protected void doTick() {
        switch (this.phase) {
            case 0: {
                this.doSpawnTick();
            }
            case 1: {
                this.doAliveTick();
                break;
            }
            case 2: {
                this.doDeadTick();
            }
        }
    }

    void doSpawnTick() {
        ++this.tick;
        if (this.tick > 60) {
            this.tick = 0;
            this.phase = 1;
        }
    }

    void doAliveTick() {
        Animation newAnim;
        float vx = 0.0f;
        float mdx = (float)Mouse.getDX() / 4.0f;
        if (mdx < 0.0f) {
            vx = Math.max(-Invaders.getGameState().getShipSpeedPerFrame() * 2.0f, mdx);
            newAnim = Res.getPlayerLeftAnimation();
        } else if (mdx > 0.0f) {
            vx = Math.min(Invaders.getGameState().getShipSpeedPerFrame() * 2.0f, mdx);
            newAnim = Res.getPlayerRightAnimation();
        } else if (Binding.isBindingDown((String)"move.left.binding") || Binding.isBindingDown((String)"move.left.binding.alt")) {
            vx = -Invaders.getGameState().getShipSpeedPerFrame();
            newAnim = Res.getPlayerLeftAnimation();
        } else if (Binding.isBindingDown((String)"move.right.binding") || Binding.isBindingDown((String)"move.right.binding.alt")) {
            vx = Invaders.getGameState().getShipSpeedPerFrame();
            newAnim = Res.getPlayerRightAnimation();
        } else {
            vx = 0.0f;
            newAnim = Res.getPlayerIdleAnimation();
        }
        if (this.getX() + vx < 12.0f && vx < 0.0f || this.getX() + vx >= (float)Invaders.getWidth() - 12.0f && vx > 0.0f) {
            vx = 0.0f;
            newAnim = Res.getPlayerIdleAnimation();
        }
        if (this.getAppearance() != newAnim) {
            this.setAppearance((AnimatedAppearance)newAnim);
        }
        this.setLocation(this.getX() + vx, this.getY());
        int i = 0;
        while (i < this.addonSprite.length) {
            if (this.addonSprite[i] != null) {
                this.addonSprite[i].setLocation((int)this.getX(), (int)this.getY(), 0);
            }
            ++i;
        }
        if (this.superGunTick > 0) {
            if (this.bulletTick > 0) {
                --this.bulletTick;
            } else if (Binding.isBindingDown((String)"shoot.binding") || Binding.isBindingDown((String)"shoot.binding.alt") || Mouse.isButtonDown((int)0)) {
                this.fire();
            }
        } else if (Binding.isBindingDown((String)"shoot.binding") || Binding.isBindingDown((String)"shoot.binding.alt") || Mouse.isButtonDown((int)0)) {
            if (!this.wasShooting) {
                this.fire();
                this.wasShooting = true;
                this.bulletTick = 20;
            } else if (this.bulletTick > 0) {
                --this.bulletTick;
            } else {
                this.fire();
                this.bulletTick = 20;
            }
        } else {
            this.wasShooting = false;
            this.bulletTick = 0;
        }
        this.tickAddons();
        if (Game.wasKeyPressed((int)2)) {
            this.enableInvulnerability(600);
        }
        if (Game.wasKeyPressed((int)3)) {
            this.enableSuperGun(300);
        }
        if (this.superGunTick > 0) {
            --this.superGunTick;
        }
        if (this.invulnTick > 0) {
            --this.invulnTick;
            if (this.invulnTick == 0) {
                if (this.invulnerabilitySound != null) {
                    this.invulnerabilitySound.deactivate();
                    this.invulnerabilitySound = null;
                }
                if (this.invulnerabilitySprite != null) {
                    this.invulnerabilitySprite.deallocate();
                    this.invulnerabilitySprite = null;
                }
            } else {
                if (this.invulnerabilitySprite != null) {
                    this.invulnerabilitySprite.setLocation((int)this.getX(), (int)this.getY() + 16, 0);
                }
                if (this.invulnTick < 60) {
                    this.invulnerabilitySprite.setVisible((this.invulnTick & 4) == 0);
                    if (this.invulnerabilitySound != null) {
                        float f = (this.invulnTick & 4) == 0 ? 1.0f * Game.getSFXVolume() : 0.0f;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("net.puppygames.applet.Game");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        this.invulnerabilitySound.setGain(f, (Object)clazz);
                    }
                }
            }
        }
        if (this.smartTick > 0) {
            --this.smartTick;
        } else if (Binding.isBindingDown((String)"smartbomb.binding") || Binding.isBindingDown((String)"smartbomb.binding.alt") || Mouse.isButtonDown((int)1)) {
            this.smartBomb();
        }
        if (this.immune > 0) {
            --this.immune;
            this.setFlash((this.immune & 2) == 2);
            i = 0;
            while (i < this.addonSprite.length) {
                if (this.addonSprite[i] != null) {
                    this.addonSprite[i].setFlash(this.isFlashing());
                }
                ++i;
            }
        }
    }

    void fire() {
        BulletFeature bf;
        if (this.superGunTick > 0) {
            this.bulletTick = 4;
            bf = BulletFeature.getSuperGun();
        } else {
            bf = BulletFeature.getGun(Invaders.getGameState().getGunPower());
        }
        Bullet b = bf.spawn(GameScreen.getInstance());
        if (b == null) {
            return;
        }
        b.setLocation(this.getX(), this.getY() + 32.0f);
    }

    private void tickAddons() {
        int i = 0;
        while (i < Invaders.getGameState().getAddOn()) {
            AddonFeature.getAddon(i).tick();
            ++i;
        }
    }

    void smartBomb() {
        if (Invaders.getGameState().getSmartBombs() == 0) {
            return;
        }
        Invaders.getGameState().adjustSmartBombs(-1);
        this.smartTick = 60;
        Smartbomb b = new Smartbomb(this.getX(), this.getY());
        SFX.smartBomb();
        b.spawn(GameScreen.getInstance());
    }

    void doDeadTick() {
        ++this.tick;
        if (this.tick > 500) {
            this.remove();
            Invaders.endGame();
        }
    }

    public boolean canCollide() {
        return this.phase == 1;
    }

    public boolean canCollideWithLaser() {
        return false;
    }

    public float getRadius() {
        if (this.invulnTick > 0) {
            return 30.0f;
        }
        return 12.0f;
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithPlayer(this);
    }

    public void onCollisionWithEnemyBullet(EnemyBullet enemyBullet) {
        this.damage();
    }

    public void onCollisionWithAlienLaser(AlienLaserEffect laserEffect) {
        if (laserEffect == this.lastLaserEffect) {
            return;
        }
        this.lastLaserEffect = laserEffect;
        this.damage();
    }

    public void onCollisionWithGidrah(Gidrah gidrah) {
        this.damage();
    }

    private void damage() {
        if (this.ultraImmune || this.immune > 0 || this.invulnTick > 0) {
            return;
        }
        boolean deactivate = Invaders.getGameState().getMultiplier() > 1;
        Invaders.getGameState().damageShields();
        this.immune = 4;
        StrobeEffect se = new StrobeEffect(Color.RED, 60);
        SFX.playerDamaged();
        se.spawn((Screen)GameScreen.getInstance());
        if (Invaders.getGameState().getShields() < 0) {
            this.kill();
        } else if (deactivate) {
            this.deactivateBonus();
        }
    }

    public void deactivateBonus() {
        LabelEffect le = new LabelEffect(Res.getSmallFont(), "Multiplier Deactivated", Color.YELLOW, Color.GREEN, 80, 40);
        le.setVelocity(0.0f, 1.0f);
        le.setAcceleration(0.0f, -0.008f);
        le.setLocation(this.getX(), this.getY());
        le.setVisible(true);
        le.setSound(Res.getBonusDeactivatedSound());
        le.spawn((Screen)GameScreen.getInstance());
    }

    void kill() {
        if (this.phase == 2) {
            return;
        }
        this.phase = 2;
        this.tick = 0;
        this.setVisible(false);
        if (this.invulnTick > 0) {
            if (this.invulnerabilitySprite != null) {
                this.invulnerabilitySprite.deallocate();
                this.invulnerabilitySprite = null;
            }
            if (this.invulnerabilitySound != null) {
                this.invulnerabilitySound.deactivate();
                this.invulnerabilitySound = null;
            }
            this.invulnTick = 0;
        }
        SFX.playerDeath();
        Emitter e = Res.getPlayerExplosionEmitter().spawn((Screen)GameScreen.getInstance());
        e.setLocation(this.getX(), this.getY());
        e.setFloor(19.0f);
        int i = 0;
        while (i < 4) {
            if (this.addonSprite[i] != null) {
                this.addonSprite[i].deallocate();
                this.addonSprite[i] = null;
            }
            ++i;
        }
        Invaders.gameOver();
    }

    public void setUltraImmune(boolean ultraImmune) {
        this.ultraImmune = ultraImmune;
    }

    public boolean hasSuperGun() {
        return this.superGunTick > 0;
    }
}

