/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.glui.font;

import java.io.IOException;
import java.net.URL;
import org.lwjgl.opengl.GL11;
import org.newdawn.glui.font.Font;
import org.newdawn.render.sprite.SpriteSheet;
import org.newdawn.render.util.Color;
import org.newdawn.util.ResourceLoader;

public class BitmapFont
extends SpriteSheet
implements Font {
    private int cWidth;
    private int cHeight;
    private byte[] widthData;

    public BitmapFont(String ref) {
        this(ref, 16, 16);
    }

    public BitmapFont(String ref, int cWidth, int cHeight) {
        super(ref, (float)cWidth, (float)cHeight);
        this.cWidth = cWidth;
        this.cHeight = cHeight;
    }

    public BitmapFont(String ref, String dat, int cWidth, int cHeight) throws IOException {
        super(ref, (float)cWidth, (float)cHeight);
        this.cWidth = cWidth;
        this.cHeight = cHeight;
        URL url = ResourceLoader.getResource((String)dat);
        this.widthData = new byte[url.openConnection().getContentLength()];
        url.openStream().read(this.widthData, 0, this.widthData.length);
    }

    public void drawString(int x, int y, String text) {
        this.drawString(x, y, text, Color.white);
    }

    public void drawString(int x, int y, String text, Color col) {
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3553);
        col.bind();
        int pos = 0;
        int count = this.texture.getTextureWidth() / this.cWidth;
        this.texture.bind();
        GL11.glBegin((int)7);
        for (int i = 0; i < text.length(); ++i) {
            int c = text.charAt(i);
            c -= 32;
            if (this.widthData != null) {
                pos -= (this.cWidth - this.widthData[c]) / 2;
            }
            this.drawQuad(x + pos, y - this.cHeight, c % count, c / count, 1.0f);
            if (this.widthData != null) {
                int xo = c % count;
                int yo = c / count;
                pos += (this.cWidth - this.widthData[c]) / 2;
                pos += this.widthData[c];
                continue;
            }
            pos += this.cWidth - 5;
        }
        GL11.glEnd();
        GL11.glPopAttrib();
    }

    public void drawOutlineString(int x, int y, String text, Color inner, Color outer) {
        this.drawString(x - 1, y - 1, text, outer);
        this.drawString(x - 1, y + 1, text, outer);
        this.drawString(x + 1, y - 1, text, outer);
        this.drawString(x + 1, y + 1, text, outer);
        this.drawString(x, y, text, inner);
    }

    public void drawArcadeString(int x, int y, String text, Color innerTop, Color innerBottom, Color outer) {
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3553);
        int pos = 0;
        int count = this.texture.getTextureWidth() / this.cWidth;
        for (int i = 0; i < text.length(); ++i) {
            int c = text.charAt(i);
            c -= 32;
            if (this.widthData != null) {
                pos -= (this.cWidth - this.widthData[c]) / 2;
            }
            outer.bind();
            this.draw(x + pos, y - this.cHeight - 2, c % count, c / count);
            this.draw(x + pos, y - this.cHeight + 2, c % count, c / count);
            this.draw(x + pos - 1, y - this.cHeight, c % count, c / count);
            this.draw(x + pos + 1, y - this.cHeight, c % count, c / count);
            this.draw(x + pos, y - this.cHeight, c % count, c / count, innerTop, innerBottom);
            if (this.widthData != null) {
                int xo = c % count;
                int yo = c / count;
                pos += (this.cWidth - this.widthData[c]) / 2;
                pos += this.widthData[c];
                continue;
            }
            pos += this.cWidth - 5;
        }
        GL11.glPopAttrib();
    }

    public int getWidth(String str) {
        if (this.widthData != null) {
            int len = 0;
            for (int i = 0; i < str.length(); ++i) {
                int c = str.charAt(i);
                len += this.widthData[c -= 32];
            }
            return len;
        }
        return str.length() * (this.cWidth - 5) + 5;
    }

    public int getHeight() {
        return this.cHeight;
    }

    public int getWidth() {
        return this.cWidth - 5;
    }
}

