/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.glui.components;

import java.util.ArrayList;
import org.newdawn.glui.components.Container;
import org.newdawn.glui.components.Label;
import org.newdawn.glui.components.RelativeLayout;
import org.newdawn.glui.components.Screen;
import org.newdawn.render.util.Color;

public class TextLines
extends Container {
    private Label[] lines;
    private int width;

    public TextLines(Screen screen, int width, int count) {
        super(screen, width, count * 20 + 10);
        this.width = width;
        this.lines = new Label[count];
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i] = new Label("");
            this.add(this.lines[i], RelativeLayout.BOTTOM_LEFT, 10, 7 + i * 20);
        }
    }

    public TextLines(Screen screen, int width, int count, Color c) {
        super(screen, width, count * 20 + 10);
        this.width = width;
        this.lines = new Label[count];
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i] = new Label("", c);
            this.add(this.lines[i], RelativeLayout.BOTTOM_LEFT, 10, 7 + i * 20);
        }
    }

    public void clear() {
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i].setText("");
        }
    }

    public void padToTop() {
        while (this.lines[this.lines.length - 1].getText().equals("")) {
            this.addLine(" ");
        }
    }

    public void addLine(String line) {
        int i;
        if (this.width <= 0) {
            return;
        }
        String[] newLines = this.split(line, this.width / 12);
        int lineCount = newLines.length;
        for (i = this.lines.length - 1; i > lineCount - 1; --i) {
            this.lines[i].setText(this.lines[i - lineCount].getText());
        }
        for (i = 0; i < lineCount; ++i) {
            this.lines[lineCount - i - 1].setText(newLines[i]);
        }
    }

    public String[] split(String source, int length) {
        ArrayList<String> list = new ArrayList<String>();
        String current = "";
        boolean lastCut = false;
        while (source.length() > length - 1) {
            boolean cut = false;
            for (int i = length - 1; i >= 0; --i) {
                if (source.charAt(i) != ' ') continue;
                list.add(source.substring(0, i));
                source = source.substring(i + 1);
                cut = true;
                break;
            }
            if (cut) continue;
            list.add(source.substring(0, length));
            source = source.substring(length);
        }
        list.add(source);
        return list.toArray(new String[0]);
    }
}

