/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.glui.components;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.newdawn.glui.components.Component;
import org.newdawn.glui.components.Container;
import org.newdawn.glui.font.Font;
import org.newdawn.render.util.Color;

public class TextField
extends Component {
    private static final int KEY_REPEAT = 75;
    private int visibleLength;
    private int totalLength;
    private Font font;
    private String text = "";
    private Color color = Color.white;
    private int cursor;
    private int offset;
    private int lastRepeat = 75;
    private int lastKey;
    private char lastChar;

    public TextField(int visibleLength, int totalLength) {
        this.visibleLength = visibleLength;
        this.totalLength = totalLength;
        this.holdsFocus = true;
    }

    public TextField(int visibleLength, int totalLength, Color color) {
        this.visibleLength = visibleLength;
        this.totalLength = totalLength;
        this.color = color;
        this.holdsFocus = true;
    }

    public void setText(String text) {
        this.text = text;
        this.cursor = Math.min(text.length(), this.totalLength - 1);
    }

    public String getText() {
        return this.text;
    }

    public void setParent(Container parent) {
        super.setParent(parent);
        if (this.font == null) {
            this.font = parent.getDefaultFont();
        }
        this.setDimensions(this.font.getWidth() * this.visibleLength, this.font.getHeight());
    }

    public void renderImpl(int xo, int yo, int delta) {
        int cpos = this.cursor * this.font.getWidth() - (this.getWidth() - this.font.getWidth());
        this.offset = cpos > 0 ? -cpos : 0;
        GL11.glTranslatef((float)this.offset, (float)0.0f, (float)0.0f);
        this.font.drawString(0, this.getHeight(), this.text, this.color);
        if (this.hasKeyFocus) {
            this.font.drawString(this.cursor * this.font.getWidth(), this.getHeight(), "_", this.color);
        }
        GL11.glTranslatef((float)(-this.offset), (float)0.0f, (float)0.0f);
    }

    public void updateImpl(int delta) {
        if (this.hasKeyFocus && Keyboard.isKeyDown((int)this.lastKey)) {
            this.lastRepeat -= delta;
            if (this.lastRepeat <= 0) {
                this.lastRepeat = 75;
                this.keyPressed(this.lastChar, this.lastKey);
            }
        }
    }

    public boolean validateCharacter(char c) {
        return c >= ' ' && c <= '}';
    }

    protected void mousePressed(int button) {
        this.parent.getScreen().setKeyFocus(this);
    }

    private void deleteChar() {
        if (this.cursor <= 0) {
            return;
        }
        String prefix = "";
        if (this.cursor > 0) {
            prefix = this.text.substring(0, this.cursor - 1);
        }
        String suffix = "";
        if (this.cursor < this.text.length()) {
            suffix = this.text.substring(this.cursor);
        }
        this.text = prefix + suffix;
        --this.cursor;
    }

    protected void insertChar(char c) {
        if (this.text.length() >= this.totalLength) {
            return;
        }
        String prefix = this.text.substring(0, this.cursor);
        String suffix = this.text.substring(this.cursor);
        this.text = prefix + c + suffix;
        if (this.text.length() < this.totalLength) {
            ++this.cursor;
        }
    }

    protected void keyPressed(char c, int key) {
        if (this.lastKey != key && this.lastChar != c) {
            this.lastRepeat = 575;
        }
        this.lastKey = key;
        this.lastChar = c;
        if (key == 211) {
            this.deleteChar();
            return;
        }
        if (key == 14) {
            this.deleteChar();
            return;
        }
        if (key == 203 && this.cursor > 0) {
            --this.cursor;
        }
        if (key == 15) {
            this.parent.screen.setKeyFocus(this.nextFocus);
            return;
        }
        if (key == 1) {
            this.parent.screen.setKeyFocus(null);
            return;
        }
        if (key == 28) {
            this.parent.screen.setKeyFocus(this.nextFocus);
            this.notifyComponentActivated();
            return;
        }
        if (key == 205 && this.cursor < this.text.length() && this.cursor < this.totalLength - 1) {
            ++this.cursor;
        }
        if (this.validateCharacter(c)) {
            this.insertChar(c);
        }
    }
}

