/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.glui.components;

import org.newdawn.glui.components.Component;
import org.newdawn.glui.components.Container;
import org.newdawn.glui.font.Font;
import org.newdawn.render.util.Color;

public class TextButton
extends Component {
    private Color mouseOver;
    private Color mouseDown;
    private Color baseCol;
    private Color col;
    private String text;
    private Font font;

    public TextButton(String text, Color col) {
        this.text = text;
        this.col = col;
        this.mouseOver = col;
        this.mouseDown = col;
        this.baseCol = col;
    }

    public TextButton(String text, Color col, Font font) {
        this(text, col);
        this.font = font;
    }

    public void setMouseDownColor(Color col) {
        this.mouseDown = col;
    }

    protected void mouseEntered() {
        this.col = this.mouseOver;
    }

    protected void mouseExited() {
        this.col = this.baseCol;
    }

    protected void mousePressed(int button) {
        this.col = this.mouseDown;
    }

    protected void mouseReleased(int button) {
        this.col = this.mouseOver;
        this.notifyComponentActivated();
    }

    public void setMouseOverColor(Color col) {
        this.mouseOver = col;
    }

    public void setParent(Container parent) {
        super.setParent(parent);
        if (this.font == null) {
            this.font = parent.getDefaultFont();
        }
        this.setText(this.text);
    }

    public void setText(String text) {
        this.text = text;
        if (this.font != null) {
            this.setDimensions(this.font.getWidth(text), this.font.getHeight());
        }
    }

    public String getText() {
        return this.text;
    }

    public void renderImpl(int xo, int yo, int delta) {
        this.font.drawString(0, this.getHeight(), this.text, this.col);
    }

    public void updateImpl(int delta) {
    }

    protected void keyPressed(char c, int key) {
        if (key == 28) {
            this.notifyComponentActivated();
        }
    }
}

