/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.glui.components;

import org.newdawn.glui.components.Component;
import org.newdawn.render.texture.Texture;

public class SkinnedButton
extends Component {
    private Texture mouseOver;
    private Texture mouseDown;
    private Texture baseCol;

    public SkinnedButton(Texture skin) {
        super(skin.getImageWidth(), skin.getImageHeight());
        this.skin = skin;
        this.mouseOver = skin;
        this.mouseDown = skin;
        this.baseCol = skin;
        this.setSkin(skin, false);
    }

    public void setMouseDownSkin(Texture skin) {
        this.mouseDown = skin;
    }

    protected void mouseEntered() {
        this.skin = this.mouseOver;
    }

    protected void mouseExited() {
        this.skin = this.baseCol;
    }

    protected void mousePressed(int button) {
        this.skin = this.mouseDown;
    }

    protected void mouseReleased(int button) {
        this.skin = this.mouseOver;
        this.notifyComponentActivated();
    }

    public void setMouseOverColor(Texture skin) {
        this.mouseOver = skin;
    }

    public void renderImpl(int xo, int yo, int delta) {
    }

    public void updateImpl(int delta) {
        this.setSkin(this.skin, true);
    }

    public void setSkin(Texture skin, boolean skinTransparent) {
        super.setSkin(skin, skinTransparent);
        this.mouseOver = skin;
        this.mouseDown = skin;
        this.baseCol = skin;
    }
}

