/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.glui.components;

import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.newdawn.glui.components.Component;
import org.newdawn.glui.components.Container;
import org.newdawn.glui.font.Font;
import org.newdawn.render.window.LWJGLWindow;

public class Screen
extends Container {
    private LWJGLWindow window;
    private Font font;
    private Component focused;

    public Screen(LWJGLWindow window, Font font) {
        super(null, window.getWidth(), window.getHeight());
        this.screen = this;
        this.window = window;
        this.font = font;
    }

    public void render(int delta) {
        this.window.enterOrtho();
        GL11.glEnable((int)3089);
        this.render(0, 0, delta);
        GL11.glDisable((int)3089);
        this.window.leaveOrtho();
    }

    public Font getDefaultFont() {
        return this.font;
    }

    public void setKeyFocus(Component focused) {
        if (this.focused != null) {
            this.focused.setHasKeyFocus(false);
        }
        this.focused = focused;
        if (this.focused != null) {
            this.focused.setHasKeyFocus(true);
        }
    }

    public void clearKeyFocus() {
        this.setKeyFocus(null);
    }

    public Component getKeyFocus() {
        return this.focused;
    }

    public void updateImpl(int delta) {
        this.considerMouseEvents(Mouse.getX(), this.getHeight() - Mouse.getY());
        while (Keyboard.next()) {
            if (this.focused == null || !this.focused.isVisible()) continue;
            if (Keyboard.getEventKeyState()) {
                this.focused.keyPressed(Keyboard.getEventCharacter(), Keyboard.getEventKey());
                continue;
            }
            this.focused.keyReleased(Keyboard.getEventCharacter(), Keyboard.getEventKey());
        }
        super.updateImpl(delta);
    }
}

