/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.glui.components;

import org.newdawn.glui.components.Component;
import org.newdawn.glui.components.Container;
import org.newdawn.glui.util.Point;

public class RelativeLayout {
    private static final int TOP_LEFT_TYPE = 1;
    private static final int BOTTOM_LEFT_TYPE = 2;
    private static final int TOP_RIGHT_TYPE = 3;
    private static final int BOTTOM_RIGHT_TYPE = 4;
    private static final int CENTER_TYPE = 5;
    public static final RelativeLayout TOP_LEFT = new RelativeLayout(1);
    public static final RelativeLayout BOTTOM_LEFT = new RelativeLayout(2);
    public static final RelativeLayout TOP_RIGHT = new RelativeLayout(3);
    public static final RelativeLayout BOTTOM_RIGHT = new RelativeLayout(4);
    public static final RelativeLayout CENTER = new RelativeLayout(5);
    private int type;

    private RelativeLayout(int type) {
        this.type = type;
    }

    public Point getRelativeToTopLeft(Container container, int x, int y, Component component) {
        switch (this.type) {
            case 1: {
                return new Point(x, y);
            }
            case 3: {
                return new Point(container.getWidth() - x - component.getWidth(), y);
            }
            case 2: {
                return new Point(x, container.getHeight() - y - component.getHeight());
            }
            case 4: {
                return new Point(container.getWidth() - x - component.getWidth(), container.getHeight() - y - component.getHeight());
            }
            case 5: {
                return new Point(container.getWidth() / 2 - component.getWidth() / 2 + x, container.getHeight() / 2 - component.getHeight() / 2 + y);
            }
        }
        throw new IllegalArgumentException("Undefined layout type");
    }
}

