/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.glui.components;

import org.newdawn.glui.components.Component;
import org.newdawn.glui.components.Container;
import org.newdawn.glui.font.Font;
import org.newdawn.render.util.Color;

public class Label
extends Component {
    private String text;
    private Color color;
    private Font font;

    public Label(String text) {
        this(text, Color.white, null);
    }

    public Label(String text, Color color) {
        super(0, 0);
        this.text = text;
        this.color = color;
    }

    public Label(String text, Color color, Font font) {
        super(0, 0);
        this.text = text;
        this.color = color;
        this.font = font;
    }

    public void setParent(Container parent) {
        super.setParent(parent);
        if (this.font == null) {
            this.font = parent.getDefaultFont();
        }
        this.setText(this.text);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (this.font != null) {
            this.setDimensions(this.font.getWidth(text), this.font.getHeight());
        }
    }

    public void renderImpl(int xo, int yo, int delta) {
        this.font.drawString(0, this.getHeight(), this.text, this.color);
    }

    public void updateImpl(int delta) {
    }
}

