/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.glui.components;

import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.newdawn.glui.components.Component;
import org.newdawn.glui.components.RelativeLayout;
import org.newdawn.glui.components.Screen;
import org.newdawn.glui.font.Font;
import org.newdawn.glui.util.Point;

public abstract class Container
extends Component {
    private ArrayList components = new ArrayList();
    protected Screen screen;

    public Container(Screen screen, int width, int height) {
        super(width, height);
        this.screen = screen;
    }

    public Screen getScreen() {
        return this.screen;
    }

    public void add(Component component, RelativeLayout layout, int x, int y) {
        ComponentRecord record = new ComponentRecord();
        record.component = component;
        record.layout = layout;
        record.x = x;
        record.y = y;
        this.components.add(record);
        component.setParent(this);
    }

    public void remove(Component component) {
        ComponentRecord record = new ComponentRecord();
        record.component = component;
        this.components.remove(record);
    }

    public Font getDefaultFont() {
        return this.screen.getDefaultFont();
    }

    void considerMouseEvents(int x, int y) {
        if (!this.visible) {
            return;
        }
        for (int i = 0; i < this.components.size(); ++i) {
            ComponentRecord record = (ComponentRecord)this.components.get(i);
            Point pt = record.layout.getRelativeToTopLeft(this, record.x, record.y, record.component);
            record.component.considerMouseEvents(x - pt.x, y - pt.y);
        }
        super.considerMouseEvents(x, y);
    }

    public void renderImpl(int xo, int yo, int delta) {
        for (int i = 0; i < this.components.size(); ++i) {
            ComponentRecord record = (ComponentRecord)this.components.get(i);
            Component comp = record.component;
            Point pt = record.layout.getRelativeToTopLeft(this, record.x, record.y, comp);
            GL11.glTranslatef((float)pt.x, (float)pt.y, (float)0.0f);
            int rely = this.screen.getHeight() - pt.y - record.component.getHeight();
            int x = pt.x - 1 + xo - comp.getXPadding();
            int y = rely - yo - comp.getYPadding() - 2;
            int width = comp.getWidth() + 2 + comp.getXPadding() * 2;
            int height = comp.getHeight() + 3 + comp.getYPadding() * 2;
            width = Math.min(width, this.getWidth() - pt.x);
            height = Math.min(height, this.getHeight() - pt.y);
            GL11.glScissor((int)x, (int)y, (int)width, (int)height);
            comp.render(xo + pt.x, yo + pt.y, delta);
            GL11.glTranslatef((float)(-pt.x), (float)(-pt.y), (float)0.0f);
        }
    }

    public void updateImpl(int delta) {
        for (int i = 0; i < this.components.size(); ++i) {
            ComponentRecord record = (ComponentRecord)this.components.get(i);
            record.component.update(delta);
        }
    }

    private class ComponentRecord {
        public Component component;
        public RelativeLayout layout;
        public int x;
        public int y;

        private ComponentRecord() {
        }

        public int hashCode() {
            return this.component.hashCode();
        }

        public boolean equals(Object other) {
            return ((ComponentRecord)other).component == this.component;
        }
    }
}

