/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.glui.components;

import java.util.ArrayList;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.newdawn.glui.components.ComponentListener;
import org.newdawn.glui.components.Container;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.util.Color;

public abstract class Component {
    private int width;
    private int height;
    protected Container parent;
    protected boolean border = false;
    protected Color borderColor = Color.white;
    protected Color background;
    protected boolean hasKeyFocus = false;
    protected boolean mouseOver = false;
    protected boolean[] mousePressed = new boolean[]{false, false, false};
    protected Texture skin;
    protected boolean skinTransparent;
    private ArrayList listeners = new ArrayList();
    private int xPad;
    private int yPad;
    protected boolean holdsFocus = false;
    protected Component nextFocus;
    protected boolean visible;
    private String actionName;

    public Component(int width, int height) {
        this.width = width;
        this.height = height;
        this.visible = true;
    }

    Component() {
        this.visible = true;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setSkin(Texture skin, boolean skinTransparent) {
        this.skin = skin;
        this.skinTransparent = skinTransparent;
    }

    public void setBorder(Color col) {
        this.borderColor = col;
        this.border = true;
    }

    public void setBackground(Color col) {
        this.background = col;
    }

    public void setParent(Container parent) {
        this.parent = parent;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public final void render(int xo, int yo, int delta) {
        if (!this.visible) {
            return;
        }
        if (this.skin != null) {
            Color.white.bind();
            this.skin.bind();
            if (this.skinTransparent) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            GL11.glEnable((int)3553);
            float tw = this.skin.getWidth();
            float th = this.skin.getHeight();
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex2f((float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)th);
            GL11.glVertex2f((float)0.0f, (float)this.height);
            GL11.glTexCoord2f((float)tw, (float)th);
            GL11.glVertex2f((float)this.width, (float)this.height);
            GL11.glTexCoord2f((float)tw, (float)0.0f);
            GL11.glVertex2f((float)this.width, (float)0.0f);
            GL11.glEnd();
            if (this.skinTransparent) {
                GL11.glEnable((int)3042);
            }
        }
        if (this.background != null) {
            this.background.bind();
            Texture.bindNone();
            GL11.glBegin((int)7);
            GL11.glVertex2f((float)(0 - this.xPad), (float)(0 - this.yPad));
            GL11.glVertex2f((float)(0 - this.xPad), (float)(this.height + this.yPad * 2));
            GL11.glVertex2f((float)(this.width + this.xPad * 2 - 2), (float)(this.height + this.yPad * 2));
            GL11.glVertex2f((float)(this.width + this.xPad * 2 - 2), (float)(0 - this.yPad));
            GL11.glEnd();
        }
        if (this.border) {
            this.borderColor.bind();
            Texture.bindNone();
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glBegin((int)7);
            GL11.glVertex2f((float)(0 - this.xPad), (float)(0 - this.yPad));
            GL11.glVertex2f((float)(0 - this.xPad), (float)(this.height + this.yPad * 2));
            GL11.glVertex2f((float)(this.width + this.xPad * 2 - 2), (float)(this.height + this.yPad * 2));
            GL11.glVertex2f((float)(this.width + this.xPad * 2 - 2), (float)(0 - this.yPad));
            GL11.glEnd();
            GL11.glPolygonMode((int)1032, (int)6914);
        }
        this.renderImpl(xo, yo, delta);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public abstract void renderImpl(int var1, int var2, int var3);

    public final void update(int delta) {
        if (!this.visible) {
            return;
        }
        this.updateImpl(delta);
    }

    public abstract void updateImpl(int var1);

    protected void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setHasKeyFocus(boolean hasKeyFocus) {
        this.hasKeyFocus = hasKeyFocus;
    }

    public boolean hasKeyFocus() {
        return this.hasKeyFocus;
    }

    public void setNextKeyFocus(Component nextFocus) {
        this.nextFocus = nextFocus;
    }

    void considerMouseEvents(int x, int y) {
        if (!this.visible) {
            return;
        }
        if (x >= 0 && y >= 0 && x <= this.width && y <= this.height) {
            if (!this.mouseOver) {
                this.mouseOver = true;
                this.mouseEntered();
            }
            for (int i = 0; i < 3; ++i) {
                if (Mouse.isButtonDown((int)i) && !this.mousePressed[i]) {
                    this.mousePressed[i] = true;
                    this.mousePressed(i);
                }
                if (Mouse.isButtonDown((int)i) || !this.mousePressed[i]) continue;
                this.mousePressed[i] = false;
                this.mouseReleased(i);
            }
        } else {
            if (this.mouseOver) {
                this.mouseOver = false;
                this.mouseExited();
            }
            for (int i = 0; i < 3; ++i) {
                this.mousePressed[i] = false;
            }
        }
    }

    protected void mouseEntered() {
    }

    protected void mouseExited() {
    }

    protected void mousePressed(int button) {
    }

    protected void mouseReleased(int button) {
    }

    protected void keyPressed(char c, int key) {
    }

    protected void keyReleased(char c, int key) {
    }

    public void addListener(ComponentListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ComponentListener l) {
        this.listeners.remove(l);
    }

    protected void notifyComponentActivated() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ComponentListener)this.listeners.get(i)).componentActivated(this);
        }
    }

    public void setPadding(int xPad, int yPad) {
        this.xPad = xPad;
        this.yPad = yPad;
    }

    int getXPadding() {
        return this.xPad;
    }

    int getYPadding() {
        return this.yPad;
    }
}

