/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.state.transitions;

import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.util.Color;
import org.newdawn.render.window.LWJGLWindow;
import org.newdawn.state.transitions.Transition;

public class FadeInTransition
implements Transition {
    public static final FadeInTransition INSTANCE = new FadeInTransition();
    private int total = 250;
    private int value;
    private Color col;

    public FadeInTransition() {
        this(Color.black);
    }

    public FadeInTransition(Color fadeFrom) {
        this.col = fadeFrom;
    }

    public void render(LWJGLWindow window, long delta) {
        if (delta > 50L) {
            delta = 50L;
        }
        float alpha = (float)this.value / (float)this.total;
        this.value = (int)((long)this.value - delta);
        window.enterOrtho();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Texture.bindNone();
        GL11.glColor4f((float)this.col.r, (float)this.col.g, (float)this.col.b, (float)alpha);
        GL11.glBegin((int)7);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)0.0f, (float)window.getHeight());
        GL11.glVertex2f((float)window.getWidth(), (float)window.getHeight());
        GL11.glVertex2f((float)window.getWidth(), (float)0.0f);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        window.leaveOrtho();
    }

    public boolean complete() {
        return this.value <= 0;
    }

    public void init() {
        this.value = this.total;
    }
}

