/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.state.loading;

import java.io.IOException;
import org.newdawn.render.window.LWJGLWindow;
import org.newdawn.state.GameState;
import org.newdawn.state.StateBasedGame;
import org.newdawn.state.loading.Loadable;
import org.newdawn.state.loading.LoadingClient;
import org.newdawn.state.loading.LoadingList;

public class LoadingGameState
implements GameState {
    protected LWJGLWindow window;
    protected LoadingClient client;
    protected Loadable nextToLoad;
    private boolean firstLoop = true;

    public LoadingGameState(LWJGLWindow window, LoadingClient client) {
        this.window = window;
        this.client = client;
    }

    public void init(StateBasedGame game) throws IOException {
    }

    public void reinit(StateBasedGame game) throws IOException {
    }

    public void render(StateBasedGame game, int delta) {
    }

    public void update(StateBasedGame game, int delta) {
        if (!this.firstLoop) {
            if (this.nextToLoad == null) {
                this.client.loadingCompleted();
            } else {
                try {
                    this.nextToLoad.load();
                }
                catch (IOException e) {
                    this.client.loadingFailed(this.nextToLoad, e);
                }
            }
        }
        this.firstLoop = false;
        this.nextToLoad = LoadingList.getNext();
    }

    public void enterState(StateBasedGame game) {
    }

    public void leaveState(StateBasedGame game) {
    }
}

