/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.state;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.newdawn.render.window.LWJGLWindow;
import org.newdawn.state.GameState;
import org.newdawn.state.transitions.NullTransition;
import org.newdawn.state.transitions.Transition;

public class StateBasedGame {
    private GameState currentState;
    private GameState newState;
    private int newStateCode;
    private Transition out;
    private Transition in;
    private HashMap states = new HashMap();
    private boolean inited = false;
    private int currentStateCode;
    private LWJGLWindow window;

    protected void setWindow(LWJGLWindow window) {
        this.window = window;
    }

    protected void resetStates() {
        this.states.clear();
        this.inited = false;
        this.currentState = null;
    }

    public void addState(int stateCode, GameState state) {
        if (this.inited) {
            throw new RuntimeException("States can only be added before initialisation");
        }
        this.states.put(new Integer(stateCode), state);
    }

    public void init(int initialStateCode) throws IOException {
        if (this.window == null) {
            throw new RuntimeException("The rendering window must be set first, see StateBasedGame.setWindow()");
        }
        if (this.inited) {
            throw new RuntimeException("Initialisation should only be called once");
        }
        this.inited = true;
        int stateCount = 0;
        Iterator gameStates = this.states.values().iterator();
        while (gameStates.hasNext()) {
            GameState state = (GameState)gameStates.next();
            ++stateCount;
            state.init(this);
        }
        this.changeToState(initialStateCode, NullTransition.INSTANCE, NullTransition.INSTANCE);
    }

    public void reinit() throws IOException {
        Iterator gameStates = this.states.values().iterator();
        while (gameStates.hasNext()) {
            GameState state = (GameState)gameStates.next();
            state.reinit(this);
        }
    }

    public void changeToState(int stateCode) {
        this.changeToState(stateCode, NullTransition.INSTANCE, NullTransition.INSTANCE);
    }

    public void changeToState(int stateCode, Transition out, Transition in) {
        this.newState = (GameState)this.states.get(new Integer(stateCode));
        if (this.newState == null) {
            throw new RuntimeException("No game state registered against the code: " + stateCode);
        }
        this.newStateCode = stateCode;
        this.out = out;
        this.in = in;
        out.init();
        in.init();
    }

    private void changeState() {
        if (this.currentState != null) {
            this.currentState.leaveState(this);
        }
        this.currentStateCode = this.newStateCode;
        this.currentState = this.newState;
        this.currentState.enterState(this);
    }

    protected int getCurrentState() {
        return this.currentStateCode;
    }

    public void render(int delta) {
        if (!this.inited) {
            throw new RuntimeException("Render may not be called before init()");
        }
        if (this.currentState != null) {
            this.currentState.render(this, delta);
        }
        if (this.out != null) {
            this.out.render(this.window, delta);
            if (this.out.complete()) {
                this.out = null;
                this.changeState();
            }
        } else if (this.in != null) {
            this.in.render(this.window, delta);
            if (this.in.complete()) {
                this.in = null;
            }
        }
    }

    public void update(int delta) {
        if (this.in != null) {
            return;
        }
        if (this.out != null) {
            return;
        }
        if (!this.inited) {
            throw new RuntimeException("Render may not be called before init()");
        }
        if (this.currentState != null) {
            this.currentState.update(this, delta);
        }
    }
}

