/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.window;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.glu.GLU;
import org.newdawn.render.texture.TGALoader;
import org.newdawn.render.util.Tuple3;
import org.newdawn.render.window.WindowListener;
import org.newdawn.util.Log;
import org.newdawn.util.ResourceLoader;

public class LWJGLWindow {
    private boolean gameRunning = true;
    private WindowListener listener;
    private long lastFPS;
    private long lastFrame;
    private int fps;
    private int width;
    private int height;
    private String title;
    private int recordedFPS;
    private boolean isoMode;
    private boolean clearBack = true;
    private boolean fullscreen;
    private PixelFormat format;
    private Object canvas;
    private boolean inited = false;
    private int remainder = 0;

    public LWJGLWindow(String title, WindowListener listener, int width, int height, boolean isoMode) {
        this.listener = listener;
        this.title = title;
        this.width = width;
        this.height = height;
        this.isoMode = isoMode;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setIcon(String ref) throws IOException {
        ByteBuffer buf = TGALoader.loadImage(ResourceLoader.getResourceAsStream((String)ref), true);
        Display.setIcon((ByteBuffer[])new ByteBuffer[]{buf});
    }

    public void setPixelFormat(PixelFormat format) {
        this.format = format;
    }

    public void setFullscreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
    }

    public static long getTime() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }

    public DisplayMode findDisplayMode(int width, int height) {
        try {
            int bpp = Display.getDisplayMode().getBitsPerPixel();
            int refresh = Display.getDisplayMode().getFrequency();
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            DisplayMode chosen = null;
            for (int i = 0; i < modes.length; ++i) {
                if (modes[i].getWidth() != width || modes[i].getHeight() != height || modes[i].getBitsPerPixel() != bpp) continue;
                chosen = modes[i];
            }
            Log.log((String)("Display chosen: " + chosen));
            return chosen;
        }
        catch (LWJGLException e) {
            return null;
        }
    }

    public boolean setDimensions(int width, int height, boolean fullscreen) {
        if (width == this.width && height == this.height) {
            if (this.fullscreen == fullscreen) {
                return false;
            }
            try {
                Display.setFullscreen((boolean)fullscreen);
                this.fullscreen = fullscreen;
                return true;
            }
            catch (LWJGLException e) {
                return false;
            }
        }
        this.width = width;
        this.height = height;
        this.fullscreen = fullscreen;
        try {
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            DisplayMode chosen = this.findDisplayMode(width, height);
            this.listener.destroy();
            Display.setDisplayMode((DisplayMode)chosen);
            Display.setFullscreen((boolean)fullscreen);
            this.initGL();
            this.listener.reinit();
        }
        catch (LWJGLException e) {
            Log.log((Throwable)e);
            Sys.alert((String)"Error", (String)e.getMessage());
            return false;
        }
        return true;
    }

    public boolean updateDisplayMode() {
        try {
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            DisplayMode chosen = this.findDisplayMode(this.width, this.height);
            if (chosen == null) {
                if (this.fullscreen) {
                    Sys.alert((String)"Error", (String)"Unabled to find display mode");
                    return false;
                }
                chosen = new DisplayMode(this.width, this.height);
            }
            Display.setDisplayMode((DisplayMode)chosen);
            Display.setTitle((String)this.title);
            Display.setFullscreen((boolean)this.fullscreen);
            if (this.format != null) {
                PixelFormat format = new PixelFormat();
                Log.log((String)("Using depth: " + format.getDepthBits()));
                Display.create((PixelFormat)format);
            } else {
                Display.create();
            }
        }
        catch (LWJGLException e) {
            Log.log((Throwable)e);
            Sys.alert((String)"Error", (String)"OpenGL init() failure. Check graphics drivers are up to date.");
            return false;
        }
        return true;
    }

    private void initGL() {
        Log.log((String)GL11.glGetString((int)7939));
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2884);
        GL11.glShadeModel((int)7425);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        if (this.isoMode) {
            FloatBuffer isoBuffer = BufferUtils.createFloatBuffer((int)16);
            isoBuffer.put(new float[]{1.0f, 0.5f, 0.0f, 0.0f, 0.0f, 2.0f, -0.1f, 0.0f, -1.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
            isoBuffer.flip();
            GL11.glMatrixMode((int)5889);
            GL11.glLoadMatrix((FloatBuffer)isoBuffer);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float s = 0.1f;
            GL11.glScalef((float)s, (float)s, (float)s);
            GL11.glHint((int)3152, (int)4354);
        } else {
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GLU.gluPerspective((float)45.0f, (float)((float)this.width / (float)this.height), (float)0.1f, (float)10.0f);
            GL11.glMatrixMode((int)5888);
            GL11.glHint((int)3152, (int)4354);
        }
        GL11.glMatrixMode((int)5888);
    }

    public void startRendering() {
        if (this.canvas != null) {
            this.lastFPS = LWJGLWindow.getTime();
            this.lastFrame = LWJGLWindow.getTime();
        } else {
            if (!this.updateDisplayMode()) {
                return;
            }
            this.init();
            this.lastFPS = LWJGLWindow.getTime();
            this.lastFrame = LWJGLWindow.getTime();
            this.gameLoop();
        }
    }

    public void init() {
        this.initGL();
        this.listener.init();
        this.inited = true;
    }

    public void enterOrtho() {
        this.enterOrtho(this.getWidth(), this.getHeight());
    }

    public void enterOrtho(int xsize, int ysize) {
        GL11.glPushAttrib((int)8448);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)-1.0, (double)1.0);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((this.getWidth() - xsize) / 2), (float)((this.getHeight() - ysize) / 2), (float)0.0f);
    }

    public void leaveOrtho() {
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public void setTitle(String title) {
        if (title.equals(this.title)) {
            return;
        }
        this.title = title;
        Display.setTitle((String)title);
    }

    public int getFPS() {
        return this.recordedFPS;
    }

    private void gameLoop() {
        while (this.gameRunning) {
            this.loop();
        }
    }

    public void loop() {
        int timeStep = 10;
        try {
            int delta = (int)(LWJGLWindow.getTime() - this.lastFrame);
            this.lastFrame = LWJGLWindow.getTime();
            int steps = delta / timeStep;
            this.remainder = delta % timeStep;
            if (!Display.isVisible()) {
                Thread.sleep(100L);
            } else {
                this.listener.update(delta);
                if (this.clearBack) {
                    GL11.glClear((int)16384);
                }
                GL11.glClear((int)256);
                GL11.glLoadIdentity();
                if (LWJGLWindow.getTime() - this.lastFPS > 1000L) {
                    this.lastFPS = LWJGLWindow.getTime();
                    this.recordedFPS = this.fps;
                    this.fps = 0;
                }
                ++this.fps;
                this.listener.render(delta);
                if (this.canvas == null) {
                    Display.update();
                }
            }
        }
        catch (Throwable e) {
            Log.log((String)"GAME LOOP EXCEPTION");
            Log.log((Throwable)e);
        }
        if (this.canvas == null && Display.isCloseRequested() && !this.listener.closeRequested()) {
            this.gameRunning = false;
            Display.destroy();
            System.exit(0);
        }
    }

    public void setClearBuffer(boolean clearBack) {
        this.clearBack = clearBack;
    }

    public final void lookAt(Tuple3 eye, Tuple3 center, Tuple3 up) {
        if (this.isoMode) {
            Log.log((String)"Attempted to use lookAt() in isometric mode! This doesn't work!");
            return;
        }
        GLU.gluLookAt((float)eye.x, (float)eye.y, (float)eye.z, (float)center.x, (float)center.y, (float)center.z, (float)up.x, (float)up.y, (float)up.z);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

