/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.util;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;

public strictfp class Tuple3 {
    public float x;
    public float y;
    public float z;

    public Tuple3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Tuple3(Tuple3 other) {
        this(other.x, other.y, other.z);
    }

    public Tuple3(float[] components) {
        if (components.length != 3) {
            throw new IllegalArgumentException("A Tuple3 takes a float[] of size 3");
        }
        this.x = components[0];
        this.y = components[1];
        this.z = components[2];
    }

    public void add(Tuple3 other) {
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
    }

    public Tuple3 copy() {
        return new Tuple3(this.x, this.y, this.z);
    }

    public FloatBuffer toFloatBuffer() {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)3);
        buffer.put(this.x).put(this.y).put(this.z);
        buffer.flip();
        return buffer;
    }

    public void sub(Tuple3 other) {
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
    }

    public Tuple3 cross(Tuple3 other) {
        return new Tuple3(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public boolean isNonZero() {
        return this.x != 0.0f || this.y != 0.0f || this.z != 0.0f;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(Tuple3 other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public void normalise() {
        float len = this.length();
        this.scale(1.0f / len);
    }

    public void scale(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
    }

    public float dot(Tuple3 other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public int hashCode() {
        return (int)(this.x * this.y * this.z);
    }

    public float distance(Tuple3 other) {
        float dx = other.x - this.x;
        float dy = other.y - this.y;
        float dz = other.z - this.z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public boolean equals(Object other) {
        if (other instanceof Tuple3) {
            Tuple3 o = (Tuple3)other;
            return o.x == this.x && o.y == this.y && o.z == this.z;
        }
        return false;
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public void extendUpTo(Tuple3 other) {
        this.x = Math.max(other.x, this.x);
        this.y = Math.max(other.y, this.y);
        this.z = Math.max(other.z, this.z);
    }

    public void extendDownTo(Tuple3 other) {
        this.x = Math.min(other.x, this.x);
        this.y = Math.min(other.y, this.y);
        this.z = Math.min(other.z, this.z);
    }
}

