/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.util;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;

public strictfp class Tuple2 {
    public float x;
    public float y;

    public Tuple2(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void scale(float l) {
        this.x *= l;
        this.y *= l;
    }

    public void add(Tuple2 other) {
        this.x += other.x;
        this.y += other.y;
    }

    public void sub(Tuple2 other) {
        this.x -= other.x;
        this.y -= other.y;
    }

    public Tuple2 copy() {
        return new Tuple2(this.x, this.y);
    }

    public FloatBuffer toFloatBuffer() {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)2);
        buffer.put(this.x).put(this.y);
        buffer.flip();
        return buffer;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public void normalise() {
        float len = this.length();
        this.x /= len;
        this.y /= len;
    }

    public float dot(Tuple2 other) {
        return this.x * other.x + this.y * other.y;
    }

    public String toString() {
        return "[Tuple2 " + this.x + "," + this.y + "]";
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(Tuple2 other) {
        this.x = other.x;
        this.y = other.y;
    }

    public void projectOntoUnit(Tuple2 b, Tuple2 result) {
        float dp = b.dot(this);
        result.x = dp * b.x;
        result.y = dp * b.y;
    }
}

