/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.util;

import org.newdawn.render.util.Tuple3;

public class Bounds {
    private Tuple3 upper = new Tuple3(0.0f, 0.0f, 0.0f);
    private Tuple3 lower = new Tuple3(0.0f, 0.0f, 0.0f);
    private Tuple3 center = new Tuple3(0.0f, 0.0f, 0.0f);
    private boolean undefined;

    public Bounds() {
        this.undefined = true;
    }

    public Bounds(Bounds other) {
        this.upper = new Tuple3(other.getUpper());
        this.lower = new Tuple3(other.getLower());
        this.center = new Tuple3(other.getCenter());
        this.undefined = false;
    }

    public Tuple3 rationalise() {
        float cx = this.upper.x * 0.5f + this.lower.x * 0.5f;
        float cy = this.upper.y * 0.5f + this.lower.y * 0.5f;
        float cz = this.upper.z * 0.5f + this.lower.z * 0.5f;
        float dx = Math.abs(this.upper.x - this.lower.x) / 2.0f;
        float dy = Math.abs(this.upper.y - this.lower.y) / 2.0f;
        float dz = Math.abs(this.upper.z - this.lower.z) / 2.0f;
        this.center = new Tuple3(cx, cy, cz);
        this.upper = new Tuple3(dx, dy, dz);
        this.lower = new Tuple3(-dx, -dy, -dz);
        return this.center;
    }

    public void add(Tuple3 pt) {
        if (this.undefined) {
            this.upper = pt.copy();
            this.lower = pt.copy();
            this.undefined = false;
            return;
        }
        this.upper.extendUpTo(pt);
        this.lower.extendDownTo(pt);
    }

    public void add(float x, float y, float z) {
        this.add(new Tuple3(x, y, z));
    }

    public Tuple3 getCenter() {
        return this.center;
    }

    public void setCenter(Tuple3 center) {
        this.center.x = center.x;
        this.center.y = center.y;
        this.center.z = center.z;
    }

    public void moveCenter(Tuple3 move) {
        this.center.add(move);
    }

    public Tuple3 getUpper() {
        return this.upper;
    }

    public Tuple3 getLower() {
        return this.lower;
    }

    public boolean intersects(Bounds other) {
        Tuple3 delta = new Tuple3(other.center);
        delta.sub(this.center);
        float dx = Math.abs(other.upper.x) + Math.abs(this.upper.x);
        float dy = Math.abs(other.upper.y) + Math.abs(this.upper.y);
        float dz = Math.abs(other.upper.z) + Math.abs(this.upper.z);
        return Math.abs(delta.x) <= dx && Math.abs(delta.y) <= dy && Math.abs(delta.z) <= dz;
    }

    public String toString() {
        return "[" + this.upper + "-" + this.lower + "]";
    }
}

