/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.tilemap.tiled3d;

import org.lwjgl.opengl.GL11;
import org.newdawn.render.tilemap.tiled3d.TileSet3D;
import org.newdawn.render.tilemap.tiled3d.TileTainter;
import org.newdawn.util.map.TileMap;

public class TileMap3D {
    private TileMap tilemap;
    private TileSet3D tileset;
    private TileTainter tainter;

    public TileMap3D(TileMap tilemap, TileSet3D tileset) {
        this.tilemap = tilemap;
        this.tileset = tileset;
    }

    public void setTainter(TileTainter tainter) {
        this.tainter = tainter;
    }

    public void render(float xo, float yo) {
        int xp = (int)xo;
        int yp = (int)yo;
        int size = 8;
        for (int y = yp - size; y < yp + size + 3; ++y) {
            for (int x = xp + size + 3; x >= xp - size - 1; --x) {
                int tile = this.tilemap.getTileAt(x, y, 0);
                boolean blocksCenter = x <= xp && y >= yp && x > xp - 2 && y < yp + 2;
                blocksCenter &= this.tileset.blocksView(tile);
                if (tile == -1) continue;
                GL11.glTranslatef((float)x, (float)y, (float)0.0f);
                if (blocksCenter) {
                    GL11.glDisable((int)2896);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)1);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
                }
                if (this.tainter != null) {
                    this.tainter.applyTaint(x, y);
                }
                this.tileset.renderTile(this.tilemap, x, y, tile);
                if (this.tainter != null) {
                    this.tainter.unapplyTaint(x, y);
                }
                if (blocksCenter) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glEnable((int)2896);
                    GL11.glDisable((int)3042);
                }
                GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
            }
        }
    }
}

